function DSGEModel = InitializeDSGEModel
% InitializeDSGEModel: Sets up the default values for the fields in the DSGEModel structure.
%
% USAGE:
%
%       DSGEModel = InitializeDSGEModel
%
% REQUIRED OUTPUT: DSGEModel (structure) whose fields contain default values.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 2, 2006.
%                        This version: February 12, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 09-08-2006: Added the fields "UseDoublingAlgorithm", "DAMaximumIterationsValue", "ShowProgress", "ShowProgressClock"
%
% * 22-08-2006: Added the field "InitializeKalman".
%
% * 30-08-2006: Added the fields "OverwriteDraws", "MarginalLikelihoodValue", "SequentialStartIteration",
%               "SequentialStepLength", "SequentialML", "CoverageStart", "CoverageIncrement", and "CoverageEnd".
%
% * 31-10-2006: Added the fields "DAToleranceValue", "RiccatiMaxIterations", and "RiccatiToleranceValue".
%
% * 17-11-2006: Changed the default value of "UseDoublingAlgorithm" reflecting that the number of options have increased
%               when computing the initial state covariance matrix for the Kalman filter. The field "StateCovConst" was
%               also added.
%
% * 20-11-2006: Added the fields "UseOwnInitialState" and "InitialStateValues".
%
% * 28-11-2006: Added the fields "PosteriorDrawsValue", "SampleBatchValue", "ParallelChainsValue", "BurnInValue",
%               "MHInitialScaleFactor", "MHScaleFactor", and "RandomWeightValue".
%
% * 30-11-2006: Changed the default value of "MarginalLikelihoodValue" from 1 to 2. This means that by default only Geweke's
%               modified harmonic mean estimator is used.
%
% * 04-12-2006: Added the fields "ShockGroupNames" and "ShockGroups".
%
% * 07-12-2006: Added the fields "OptMaxIterationsValue", "OptToleranceValue", "MaximizeAlgorithmValue", "StepLengthHessian",
%               "NumberOfGridPoints", "FiniteDifferenceHessian", "CheckOptimum", "CheckTransformedOptimum", "GridWidth",
%               "IRHorizon", "PriorKernel", "KernelDensityValue", and "KernelDensityEstimator".
%
% * 08-12-2006: The field "levels" is now initialized.
%
% * 15-12-2006: Added the field "PosteriorDensityValue".
%
% * 18-12-2006: Added the field "RandomNumberValue".
%
% * 21-12-2006: The ranges of "MHScaleFactor" and "MHInitialScaleFactor" were changed in YADAGUI.m. The default values of
%               the field entries therefore needed to be adjusted. The field "MaxForecastHorizon" was also added.
%
% * 22-12-2006: Added the field "FreqParameterReest".
%
% * 05-01-2007: Added the field "ShockGroupColors".
%
% * 11-01-2007: Added the fields "BVARLags", "HarmonicLagDecayValue", "CrossEqTightnessValue", "OverallTightnessValue",
%               "PriorType", "PriorLevelMeanValue", and "PriorDiffMeanValue".
%
% * 12-01-2007: Added the fields "OmegaPriorType", "WishartType", "VarianceTightnessValue", "WishartDFValue",
%               "SteadyStatePriorFile", "BVARY", and "BVARX".
%
% * 22-01-2007: The field "annual" is now initialized.
%
% * 25-01-2007: The field "annualscale" is now initialized.
%
% * 16-02-2007: The field "PredictedX" is now initialized.
%
% * 20-02-2007: The field "Percentiles" is now initialized.
%
% * 22-02-2007: The fields "NumPredPathsValue" and "PostDrawsUsageValue" are now initialized.
%
% * 26-02-2007: The field "RandomizeDraws" is now initialized.
%
% * 28-02-2007: The field "ConfidenceBandBaseColor" is now initialized.
%
% * 08-03-2007: Added the fields "Z", "ZVariableNames", "K1", "K2", "U", "ConditionalShocks", and "ConditionalVariables".
%
% * 03-04-2007: Added the field "PostDrawsPercentValue".
%
% * 10-04-2007: Added the field "InverseHessianEstimator".
%
% * 16-04-2007: Added the field "MaxCorrelationValue".
%
% * 25-04-2007: Added the fields "C", "CVariableNames", "C1", "C2", "CBar", "ScenarioShocks", and "ScenarioVariables".
%
% * 26-04-2007: Added the fields "AnnScenarioValue" and "ScenarioValue".
%
% * 02-05-2007: Added the field "ScenarioParameters".
%
% * 03-05-2007: Added the field "PredictionEvent".
%
% * 08-05-2007: Fixed a bug when trying to initialize ScenarioVariables.
%
% * 23-08-2007: Added the field "AdjustPredictionPaths".
%
% * 28-09-2007: Fixed a spelling bug "CvariableNames" for "CVariableNames". Added the fields "ObsVariableScenarioFile",
%               "CData", and "CDataComment".
%
% * 09-10-2007: The fields "CDataOriginal", "CVariableNamesOriginal", "CDataCommentOriginal", "C1Original",
%               "C2Original", and "CBarOriginal" are now taken into account.
%
% * 22-10-2007: The fields "YTransformation", "CTransformation", and "CTransformationOriginal" are taken into account.
%
% * 23-10-2007: The fields "ZTransformation" and "ZTransformationOriginal" are now taken into account.
%
% * 25-10-2007: The field "FreqParameterReest" is no longer supported.
%
% * 26-10-2007: The field "ParameterScenario" is now supported.
%
% * 31-10-2007: The field "OVSComparisonFile" is now supported.
%
% * 06-11-2007: Updated the documentation.
%
% * 17-12-2007: Added the field "ShockControlMethod".
%
% * 20-12-2007: Added the field "UnitRootStates".
%
% * 02-01-2008: Added the field "KalmanFirstObservation".
%
% * 09-01-2008: Added the field "CompData".
%
% * 11-01-2008: Added the field "CompY".
%
% * 22-01-2008: The field "OVSComparisonFile" is no longer supported.
%
% * 23-01-2008: The default value of "MaxForecastHorizon" is now 1.
%
% * 24-01-2008: Added the field "KsiUseCondData".
%
% * 31-01-2008: Added the fields "OrigScenarioVariables", "OrigScenarioShocks", "ShockColorStart", and "ShockColorEnd".
%
% * 18-02-2008: Added the field "ModifiedHessian".
%
% * 28-03-2008: Added the fields "CExport" and "COrder".
%
% * 16-05-2008: Added the field "AIMTolerance".
%
% * 23-05-2008: Updated the documentation.
%
% * 26-05-2008: The "SequentialML" variable now has the default value 0. The "PostDrawsUsageValue" variable now has
%               default value 1. The "MHInitialScaleFactor" variable now has default value 1.
%
% * 02-07-2008: Added the field "AllowUnitRoot".
%
% * 28-07-2008: Added the field "ParameterScenarioValue".
%
% * 01-08-2008: The fields "YData" and "YDataOriginal" are now specified.
%
% * 13-08-2008: Added the field "CompCBar".
%
% * 20-08-2008: Added the field "CExportVariables".
%
% * 28-08-2008: Added the field "CCreateData".
%
% * 19-12-2008: Updated the documentation.
%
% * 29-01-2009: Added the field "InitializeHessian".
%
% * 12-02-2009: Added the field "ParameterCovMatrix".
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

DSGEModel.AIMFile = pwd;
DSGEModel.AIMDataFile = pwd;
DSGEModel.NameOfModel = '';
DSGEModel.DataConstructionFile = pwd;
DSGEModel.T = 0;
DSGEModel.n = 0;
DSGEModel.k = 0;
DSGEModel.Y = [];
DSGEModel.YData = [];
DSGEModel.YDataOriginal = [];
DSGEModel.levels = [];
DSGEModel.annual = [];
DSGEModel.annualscale = [];
DSGEModel.X = [];
DSGEModel.DataFrequency = '';
DSGEModel.BeginYear = '';
DSGEModel.BeginPeriod = '';
DSGEModel.EndYear = '';
DSGEModel.EndPeriod = '';
DSGEModel.SubBeginYear = '';
DSGEModel.SubBeginPeriod = '';
DSGEModel.SubEndYear = '';
DSGEModel.SubEndPeriod = '';
DSGEModel.VariableNames = '';
DSGEModel.XVariableNames = '';
DSGEModel.PriorFile = pwd;
DSGEModel.PriorFileSheet = 'None';
DSGEModel.MeasurementEquationFile = pwd;
DSGEModel.OutputDirectory = pwd;
DSGEModel.UpdateParameterFile = pwd;
DSGEModel.InitializeParameterFile = pwd;
DSGEModel.RunInitializeFirst = 0;
DSGEModel.UseDoublingAlgorithm = 2;
DSGEModel.DAMaximumIterationsValue = 1;
DSGEModel.ShowProgress = 1;
DSGEModel.ShowProgressClock = 0;
DSGEModel.StateShockNames = '';
DSGEModel.StateShockPositions = [];
DSGEModel.StateVariableNames = '';
DSGEModel.StateVariablePositions = [];
DSGEModel.InitializeKalman = 1;
DSGEModel.KalmanFirstObservation = 1;
DSGEModel.OverwriteDraws = 0;
DSGEModel.MarginalLikelihoodValue = 2;
DSGEModel.SequentialStartIteration = 4;
DSGEModel.SequentialStepLength = 4;
DSGEModel.SequentialML = 0;
DSGEModel.CoverageStart = 2;
DSGEModel.CoverageIncrement = 2;
DSGEModel.CoverageEnd = 9;
DSGEModel.DAToleranceValue = 7;
DSGEModel.RiccatiMaxIterations = 10;
DSGEModel.RiccatiToleranceValue = 7;
DSGEModel.StateCovConst = 19;
DSGEModel.UseOwnInitialState = 0;
DSGEModel.InitialStateValues = [];
DSGEModel.PosteriorDrawsValue = 1;
DSGEModel.SampleBatchValue = 1;
DSGEModel.ParallelChainsValue = 1;
DSGEModel.BurnInValue = 1;
DSGEModel.MHInitialScaleFactor = 1;
DSGEModel.MHScaleFactor = 26;
DSGEModel.RandomWeightValue = 6;
DSGEModel.ShockGroupNames = '';
DSGEModel.ShockGroups = [];
DSGEModel.ShockGroupColors = [];
DSGEModel.ShockColorStart = [];
DSGEModel.ShockColorEnd = [];
DSGEModel.OptMaxIterationsValue = 1;
DSGEModel.OptToleranceValue = 4;
DSGEModel.MaximizeAlgorithmValue = 1;
DSGEModel.StepLengthHessian = 12;
DSGEModel.NumberOfGridPoints = 3;
DSGEModel.FiniteDifferenceHessian = 0;
DSGEModel.CheckOptimum = 1;
DSGEModel.CheckTransformedOptimum = 1;
DSGEModel.GridWidth = 4;
DSGEModel.IRHorizon = 10;
DSGEModel.PriorKernel = 0;
DSGEModel.KernelDensityValue = 2;
DSGEModel.KernelDensityEstimator = 'kepan';
DSGEModel.PosteriorDensityValue = 1;
DSGEModel.RandomNumberValue = 0;
DSGEModel.MaxForecastHorizon = 1;
%DSGEModel.FreqParameterReest = 1;
DSGEModel.BVARLags = 4;
DSGEModel.HarmonicLagDecayValue = 2;
DSGEModel.CrossEqTightnessValue = 10;
DSGEModel.OverallTightnessValue = 4;
DSGEModel.PriorType = 1;
DSGEModel.PriorLevelMeanValue = 1;
DSGEModel.PriorDiffMeanValue = 1;
DSGEModel.OmegaPriorType = 1;
DSGEModel.WishartType = 1;
DSGEModel.VarianceTightnessValue = 20;
DSGEModel.WishartDFValue = 1;
DSGEModel.SteadyStatePriorFile = pwd;
DSGEModel.BVARY = [];
DSGEModel.BVARX = [];
DSGEModel.PredictedX = [];
DSGEModel.Percentiles = [5 15 85 95];
DSGEModel.NumPredPathsValue = 1;
DSGEModel.PostDrawsUsageValue = 1;
DSGEModel.RandomizeDraws = 0;
DSGEModel.ConfidenceBandBaseColor = [1 1 1];
DSGEModel.Z = [];
DSGEModel.ZVariableNames = '';
DSGEModel.K1 = [];
DSGEModel.K2 = [];
DSGEModel.U = [];
DSGEModel.ConditionalShocks = [];
DSGEModel.ConditionalVariables = [];
DSGEModel.PostDrawsPercentValue = 109;
DSGEModel.InverseHessianEstimator = 1;
DSGEModel.MaxCorrelationValue = 1;
DSGEModel.C = [];
DSGEModel.CData = [];
DSGEModel.CompData = [];
DSGEModel.CDataComment = '';
DSGEModel.CVariableNames = '';
DSGEModel.C1 = [];
DSGEModel.C2 = [];
DSGEModel.CBar = [];
DSGEModel.CompCBar = [];
DSGEModel.CDataOriginal = [];
DSGEModel.CDataCommentOriginal = '';
DSGEModel.CVariableNamesOriginal = '';
DSGEModel.C1Original = [];
DSGEModel.C2Original = [];
DSGEModel.CBarOriginal = [];
DSGEModel.ScenarioShocks = [];
DSGEModel.ScenarioVariables = [];
DSGEModel.ScenarioValue = 1;
DSGEModel.AnnScenarioValue = 1;
DSGEModel.ScenarioParameters = [];
DSGEModel.PredictionEvent = [];
DSGEModel.AdjustPredictionPaths = 1;
DSGEModel.KsiUseCondData = 0;
DSGEModel.ObsVariableScenarioFile = '';
DSGEModel.CTransformation = [];
DSGEModel.YTransformation = [];
DSGEModel.CTransformationOriginal = [];
DSGEModel.ZTransformation = [];
DSGEModel.ZTransformationOriginal = [];
DSGEModel.ParameterScenario = [];
DSGEModel.ShockControlMethod = 1;
DSGEModel.UnitRootStates = [];
DSGEModel.CompY = [];
DSGEModel.OrigScenarioVariables = [];
DSGEModel.OrigScenarioShocks = [];
DSGEModel.ModifiedHessian = 0;
DSGEModel.CExport = [];
DSGEModel.CExportVariables = [];
DSGEModel.CCreateData = [];
DSGEModel.COrder = [];
DSGEModel.AIMTolerance = 6;
DSGEModel.AllowUnitRoot = 0;
DSGEModel.ParameterScenarioValue = 1;
DSGEModel.InitializeHessian = 5;
DSGEModel.ParameterCovMatrix = 'none';

%
% end of InitializeDSGEModel.m
%
