function [FontName,FontSize,FontAngle,FontWeight] = GetUIFont
% GetUIFont: Gets the system dependent font name, size, weight and angle for uicontrols.
%
% USAGE:
%
%       [FontName,FontSize,FontAngle,FontWeight] = GetUIFont
%
% REQUIRED OUTPUT: FontName (string vector) with the name of the system dependent font.
%
%                  FontSize (integer) with the system dependent font size.
%
%                  FontAngle (string vector) with the system dependent font angle.
%
%                  FontWeight (string vector) with the system dependent font weight.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 21, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 26-3-2008:  Updated the documentation and added the output variables "FontAngle" and "FontWeight".
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% create an invisible figure with a pushbutton and a text string
%
fig = figure('visible','off', ...
             'position',[0 0 200 100], ...
             'menubar','none', ...
             'toolbar','none', ...
             'tag','tempfig');
%
uc = uicontrol('parent',fig, ...
             'position',[10 10 100 20], ...
             'string','text');
%
% retrieve system dependent font properties
%
FontName = get(uc,'FontName');
FontSize = get(uc,'FontSize');
FontAngle = get(uc,'FontAngle');
FontWeight = get(uc,'FontWeight');
%
close(fig);

%
% end of GetUIFont.m
%
