function FixTabs(Controls,OldTab,NewTab)
% FixTabs: Sets the correct cdata for the buttons on the tabs under Windows XP
%          with Matlab 7 or later
%
% USAGE:
%
%       FixTabs(Controls,OldTab,NewTab)
%
% REQUIRED INPUT: Controls (structure) with handles to all controls on the main
%                          program window in YADA.
%
%                 OldTab (integer) representing the value of the currently
%                          shown tab.
%
%                 NewTab (integer) representing the value of the tab to be
%                          shown.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 24, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 20-5-2008:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% get the handles to the old and the new tab
%
OldTabHandle = getfield(Controls,['tab' num2str(OldTab,'%0.0f')]);
NewTabHandle = getfield(Controls,['tab' num2str(NewTab,'%0.0f')]);
%
% get the cdata from the old and the new tab
%
OldCData = get(OldTabHandle,'CData');
NewCData = get(NewTabHandle,'CData');
%
% swap the cdata
%
set(OldTabHandle,'CData',NewCData);
set(NewTabHandle,'CData',OldCData);

%
% end of FixTabs.m
%
