function [action,OutTextStr] = EditDLG(NameStr,EditTitle,TextStr,width,CurrINI)
% EditDLG: Displays and edit dialog with an OK and a Cancel button.
%
% USAGE:
%
%       [action,OutTextStr] = EditDLG(NameStr,EditTitle,TextStr,width,CurrINI)
%
% OPTIONAL INPUT:  NameStr (string vector) with the figure name.
%
%                  EditTitle (string vector) with the title for the edit object.
%
%                  TextStr (string vector) with the text for the edit dialog.
%
%                  width (integer) width the dialog width in pixel units. The default
%                        value is 500.
%
%                  CurrINI (structure) with initialization information.
%
% REQUIRED OUTPUT: action (string vector) that is either "OK" or "Cancel", where
%                        the latter is the default.
%
%                  OutTextStr (string vector) with the text in the dit dialog.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 1, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 11-5-2007:  Updated the documentation.
%
% * 1-8-2007:   Fixed the call to the "CloseGUI" function.
%
% * 9-11-2007:  Updated the documentation.
%
% * 10-1-2008:  Changed the last drawnow call to pause(0.02).
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% initialize
%
if nargin==0;
   NameStr = 'Text Dialogue';
   EditTitle = 'Enter Text:';
   TextStr = 'text';
elseif nargin==1;
   if isstr(NameStr)==0;
      NameStr = 'Text Dialogue';
   end;
   EditTitle = 'Enter Text:';
   TextStr = 'text';
elseif nargin==2;
   if isstr(NameStr)==0;
      NameStr = 'Text Dialogue';
   end;
   if isstr(EditTitle)==0;
      EditTitle = 'Enter Text:';
   end;
   TextStr = 'text';
else;
   if isstr(NameStr)==0;
      NameStr = 'Text Dialogue';
   end;
   if isstr(EditTitle)==0;
      EditTitle = 'Enter Text:';
   end;
   if isstr(TextStr)==0;
      TextStr = 'text';
   end;
end;
if nargin<4;
   width = 500;
end;
if nargin<5;
   CurrINI = InitializeINIFile;
end;
%
scrsz = get(0,'ScreenSize');
%
editgui = figure('Color',get(0,'defaultuicontrolbackgroundcolor'), ...
   'FileName','EditDLG.m', ...
   'MenuBar','none', ...
   'Units','pixels', ...
   'Position',[(scrsz(3)-width)/2 (scrsz(4)-110)/2 width 110], ...
   'Tag','FigEditDLG', ...
   'Resize','off', ...
   'Name',NameStr, ...
   'Visible','off', ...
   'NumberTitle','off', ...
   'WindowStyle','modal', ...
   'CloseRequestFcn','CloseGUI', ...
   'ToolBar','none');
%
if matlabnumber>=7.0;
   set(editgui,'DockControl','off');
end;
%
uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[12 75 width-24 20], ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Style','text', ...
   'HorizontalAlignment','left', ...
   'String',EditTitle, ...
   'Tag','Text');
%
edits.edit = uicontrol('Units','pixels', ...
   'BackgroundColor',[1 1 1], ...
   'Position',[12 50 width-24 25], ...
   'Value',1, ...
   'String',TextStr, ...
   'Style','edit', ...
   'HorizontalAlignment','left', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Tag','EditEdit');
%
% Two buttons to select action
%
edits.ok = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[((width-5)/2)-50 12 50 25], ...
   'String','OK', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Callback','CloseGUI', ...
   'UserData','waiting', ...
   'Tag','ButtonOK');
%
edits.cancel = uicontrol('Units','pixels', ...
   'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
   'Position',[(width+5)/2 12 50 25], ...
   'String','Cancel', ...
   'FontSize',CurrINI.gui_fontsize, ...
   'FontName',CurrINI.gui_fontname, ...
   'FontWeight',CurrINI.gui_fontweight, ...
   'FontAngle',CurrINI.gui_fontangle, ...
   'Enable','on', ...
   'Callback','CloseGUI', ...
   'Tag','ButtonCancel');
%
set(editgui,'Visible','on');
drawnow;
drawnow;
if MatlabNumber>=7;
   uicontrol(edits.ok);
end;
waitfor(editgui,'waitstatus','inactive');
%
if (isempty(get(editgui,'CurrentObject'))==1)|(strcmp(get(get(editgui,'CurrentObject'),'Type'),'uicontrol')==0);
   action = 'Cancel';
else;
   action = get(get(editgui,'CurrentObject'),'String');
   if isempty(action)==1;
      action = 'Cancel';
   end;
end;
%
if strcmp(action,'Cancel')==0;
   OutTextStr = get(edits.edit,'String');
else;
   OutTextStr = '';
end;
%
delete(editgui);
drawnow;
pause(0.02);

%
% end of EditDLG.m
%
