function status = CompareDSGEModel(DSGEModel,OrigDSGEModel)
% CompareDSGEModel: Compares the current DSGEModel structure with the last saved structure. Returns 0
%                   if they are different and 1 otherwise.
%
% USAGE:
%
%       status = CompareDSGEModel(DSGEModel,OrigDSGEModel)
%
% REQUIRED INPUT:  DSGEModel (structure) whose fields contain all required information
%                            about the model, such as input files, variable and sample
%                            data. Actual observations are not stored in this file.
%
%                  OrigDSGEModel (structure) whose fields are identical to the DSGEModel
%                            structure, but where OrigDSGEModel contains the last saved
%                            values, while DSGEModel has values that may have changed since
%                            the last save.
%
% REQUIRED OUTPUT: status (boolean) which is one if the structures have identical values and
%                            0 otherwise.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 9, 2006.
%                        This version: February 12, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 22-08-2006: Added the field "InitializeKalman".
%
% * 30-08-2006: Added the fields "OverwriteDraws", "MarginalLikelihoodValue", "SequentialStartIteration",
%               "SequentialStepLength", "SequentialML", "CoverageStart", "CoverageIncrement", and "CoverageEnd".
%
% * 17-10-2006: Fixed a bug when comparing StateShockPositions to their original values and StateVariablePositions to their
%               original values.
%
% * 31-10-2006: Added the fields "DAToleranceValue", "RiccatiMaxIterations", and "RiccatiToleranceValue".
%
% * 20-11-2006: Added the fields "StateCovConst", "UseOwnInitialState".
%
% * 27-11-2006: made sure that the string matrices "DSGEModel.StateShockNames" and "DSGEModel.StateVariableNames" are
%               compared with their original matrices.
%
% * 28-11-2006: Added the fields "PosteriorDrawsValue", "SampleBatchValue", "ParallelChainsValue", "BurnInValue",
%               "MHInitialScaleFactor", "MHScaleFactor", and "RandomWeightValue".
%
% * 04-12-2006: Added the fields "ShockGroupNames" and "ShockGroups".
%
% * 07-12-2006: Added the fields "OptMaxIterationsValue", "OptToleranceValue", "MaximizeAlgorithmValue", "StepLengthHessian",
%               "NumberOfGridPoints", "FiniteDifferenceHessian", "CheckOptimum", "CheckTransformedOptimum", "GridWidth",
%               "IRHorizon", "PriorKernel", "KernelDensityValue", and "KernelDensityEstimator".
%
% * 15-12-2006: Added the field "PosteriorDensityValue".
%
% * 18-12-2006: Added the field "RandomNumberValue".
%
% * 21-12-2006: Added the field "MaxForecastHorizon".
%
% * 22-12-2006: Added the field "FreqParameterReest".
%
% * 05-01-2007: Added the field "ShockGroupColors".
%
% * 11-01-2007: Added the fields "BVARLags", "HarmonicLagDecayValue", "CrossEqTightnessValue", "OverallTightnessValue",
%               "PriorType", and "PriorDiffMeanValue".
%
% * 12-01-2007: Added the fields "OmegaPriorType", "WishartType", "VarianceTightnessValue", "WishartDFValue",
%               "SteadyStatePriorFile", "BVARY", and "BVARX".
%
% * 22-02-2007: Added the fields "NumPredPathsValue" and "PostDrawsUsageValue".
%
% * 26-02-2007: Added the field "RandomizeDraws".
%
% * 28-02-2007: Added the field "ConfidenceBandBaseColor".
%
% * 08-03-2007: Added the fields "ConditionalShocks" and "ConditionalVariables".
%
% * 03-04-2007: Added the field "PostDrawsPercentValue".
%
% * 10-04-2007: Added the field "InverseHessianEstimator".
%
% * 16-04-2007: Added the field "MaxCorrelationValue".
%
% * 25-04-2007: Added the fields "ScenarioShocks", and "ScenarioVariables".
%
% * 26-04-2007: Added the fields "AnnScenarioValue" and "ScenarioValue".
%
% * 02-05-2007: Added the field "ScenarioParameters".
%
% * 03-05-2007: Added the field "PredictionEvent".
%
% * 04-05-2007: Made sure the function treats potential Inf and -Inf values correctly for the "PredictionEvent" matrix.
%
% * 23-08-2007: Added the field "AdjustPredictionPaths".
%
% * 28-09-2007: Added the field "ObsVariableScenarioFile".
%
% * 25-10-2007: The field "FreqParameterReest" is no longer supported.
%
% * 26-10-2007: Added the field "ParameterScenario".
%
% * 06-11-2007: Added the field "OVSComparisonFile".
%
% * 17-12-2007: Added the field "ShockControlMethod".
%
% * 20-12-2007: Added the field "UnitRootStates".
%
% * 02-01-2008: Added the field "KalmanFirstObservation" and removed the field "InitializeKalman".
%
% * 22-01-2008: The field "OVSComparisonFile" is no longer supported.
%
% * 24-01-2008: Added the field "KsiUseCondData".
%
% * 31-01-2008: Added the fields "ShockColorStart" and "ShockColorEnd".
%
% * 18-02-2008: Added the field "ModifiedHessian".
%
% * 16-05-2008: Added the field "AIMTolerance".
%
% * 21-05-2008: Fixed a bug regarding the placement of the tests for the "StateShockPositions" and the
%               "StateVariablePositions".
%
% * 23-05-2008: Updated the documentation.
%
% * 02-07-2008: Added the field "AllowUnitRoot".
%
% * 28-07-2008: Added the field "ParameterScenarioValue".
%
% * 19-12-2008: Updated the documentation.
%
% * 29-01-2009: Added the field "InitializeHessian".
%
% * 12-02-2009: Added the field "ParameterCovMatrix".
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

status = 0;
if strcmp(lower(DSGEModel.DataConstructionFile),lower(OrigDSGEModel.DataConstructionFile))==0;
   return;
end;
if strcmp(lower(DSGEModel.MeasurementEquationFile),lower(OrigDSGEModel.MeasurementEquationFile))==0;
   return;
end;
if strcmp(lower(DSGEModel.PriorFile),lower(OrigDSGEModel.PriorFile))==0;
   return;
end;
if strcmp(lower(DSGEModel.PriorFileSheet),lower(OrigDSGEModel.PriorFileSheet))==0;
   return;
end;
if strcmp(lower(DSGEModel.UpdateParameterFile),lower(OrigDSGEModel.UpdateParameterFile))==0;
   return;
end;
if strcmp(lower(DSGEModel.InitializeParameterFile),lower(OrigDSGEModel.InitializeParameterFile))==0;
   return;
end;
if strcmp(lower(DSGEModel.AIMFile),lower(OrigDSGEModel.AIMFile))==0;
   return;
end;
if strcmp(lower(DSGEModel.AIMDataFile),lower(OrigDSGEModel.AIMDataFile))==0;
   return;
end;
if strcmp(lower(DSGEModel.NameOfModel),lower(OrigDSGEModel.NameOfModel))==0;
   return;
end;
if strcmp(lower(DSGEModel.OutputDirectory),lower(OrigDSGEModel.OutputDirectory))==0;
   return;
end;
if (isequal(DSGEModel.StateVariableNames,OrigDSGEModel.StateVariableNames)==0)|(length(DSGEModel.StateVariablePositions)~=length(OrigDSGEModel.StateVariablePositions))|(sum(abs(DSGEModel.StateVariablePositions-OrigDSGEModel.StateVariablePositions))>0);
   return;
end;
if (isequal(DSGEModel.StateShockNames,OrigDSGEModel.StateShockNames)==0)|(length(DSGEModel.StateShockPositions)~=length(OrigDSGEModel.StateShockPositions))|(sum(abs(DSGEModel.StateShockPositions-OrigDSGEModel.StateShockPositions))>0);
   return;
end;
if strcmp(DSGEModel.SubBeginYear,OrigDSGEModel.SubBeginYear)==0;
   return;
end;
if strcmp(DSGEModel.SubBeginPeriod,OrigDSGEModel.SubBeginPeriod)==0;
   return;
end;
if strcmp(DSGEModel.SubEndYear,OrigDSGEModel.SubEndYear)==0;
   return;
end;
if strcmp(DSGEModel.SubEndPeriod,OrigDSGEModel.SubEndPeriod)==0;
   return;
end;
if abs(DSGEModel.RunInitializeFirst-OrigDSGEModel.RunInitializeFirst)>0;
   return;
end;
if abs(DSGEModel.UseDoublingAlgorithm-OrigDSGEModel.UseDoublingAlgorithm)>0;
   return;
end;
if abs(DSGEModel.DAMaximumIterationsValue-OrigDSGEModel.DAMaximumIterationsValue)>0;
   return;
end;
if abs(DSGEModel.ShowProgress-OrigDSGEModel.ShowProgress)>0;
   return;
end;
if abs(DSGEModel.ShowProgressClock-OrigDSGEModel.ShowProgressClock)>0;
   return;
end;
if abs(DSGEModel.KalmanFirstObservation-OrigDSGEModel.KalmanFirstObservation)>0;
   return;
end;
if abs(DSGEModel.OverwriteDraws-OrigDSGEModel.OverwriteDraws)>0;
   return;
end;
if abs(DSGEModel.MarginalLikelihoodValue-OrigDSGEModel.MarginalLikelihoodValue)>0;
   return;
end;
if abs(DSGEModel.SequentialStartIteration-OrigDSGEModel.SequentialStartIteration)>0;
   return;
end;
if abs(DSGEModel.SequentialStepLength-OrigDSGEModel.SequentialStepLength)>0;
   return;
end;
if abs(DSGEModel.SequentialML-OrigDSGEModel.SequentialML)>0;
   return;
end;
if abs(DSGEModel.CoverageStart-OrigDSGEModel.CoverageStart)>0;
   return;
end;
if abs(DSGEModel.CoverageIncrement-OrigDSGEModel.CoverageIncrement)>0;
   return;
end;
if abs(DSGEModel.CoverageEnd-OrigDSGEModel.CoverageEnd)>0;
   return;
end;
if abs(DSGEModel.DAToleranceValue-OrigDSGEModel.DAToleranceValue)>0;
   return;
end;
if abs(DSGEModel.RiccatiMaxIterations-OrigDSGEModel.RiccatiMaxIterations)>0;
   return;
end;
if abs(DSGEModel.RiccatiToleranceValue-OrigDSGEModel.RiccatiToleranceValue)>0;
   return;
end;
if abs(DSGEModel.StateCovConst-OrigDSGEModel.StateCovConst)>0;
   return;
end;
if abs(DSGEModel.UseOwnInitialState-OrigDSGEModel.UseOwnInitialState)>0;
   return;
end;
if (length(DSGEModel.InitialStateValues)~=length(OrigDSGEModel.InitialStateValues))|(sum(abs(DSGEModel.InitialStateValues-OrigDSGEModel.InitialStateValues))>0);
   return;
end;
if abs(DSGEModel.PosteriorDrawsValue-OrigDSGEModel.PosteriorDrawsValue)>0;
   return;
end;
if abs(DSGEModel.SampleBatchValue-OrigDSGEModel.SampleBatchValue)>0;
   return;
end;
if abs(DSGEModel.ParallelChainsValue-OrigDSGEModel.ParallelChainsValue)>0;
   return;
end;
if abs(DSGEModel.BurnInValue-OrigDSGEModel.BurnInValue)>0;
   return;
end;
if abs(DSGEModel.MHInitialScaleFactor-OrigDSGEModel.MHInitialScaleFactor)>0;
   return;
end;
if abs(DSGEModel.MHScaleFactor-OrigDSGEModel.MHScaleFactor)>0;
   return;
end;
if abs(DSGEModel.RandomWeightValue-OrigDSGEModel.RandomWeightValue)>0;
   return;
end;
if (isequal(DSGEModel.ShockGroupNames,OrigDSGEModel.ShockGroupNames)==0)|(length(DSGEModel.ShockGroups)~=length(OrigDSGEModel.ShockGroups))|(sum(abs(DSGEModel.ShockGroups-OrigDSGEModel.ShockGroups))>0);
   return;
end;
if abs(DSGEModel.OptMaxIterationsValue-OrigDSGEModel.OptMaxIterationsValue)>0;
   return;
end;
if abs(DSGEModel.OptToleranceValue-OrigDSGEModel.OptToleranceValue)>0;
   return;
end;
if abs(DSGEModel.MaximizeAlgorithmValue-OrigDSGEModel.MaximizeAlgorithmValue)>0;
   return;
end;
if abs(DSGEModel.StepLengthHessian-OrigDSGEModel.StepLengthHessian)>0;
   return;
end;
if abs(DSGEModel.NumberOfGridPoints-OrigDSGEModel.NumberOfGridPoints)>0;
   return;
end;
if abs(DSGEModel.FiniteDifferenceHessian-OrigDSGEModel.FiniteDifferenceHessian)>0;
   return;
end;
if abs(DSGEModel.CheckOptimum-OrigDSGEModel.CheckOptimum)>0;
   return;
end;
if abs(DSGEModel.CheckTransformedOptimum-OrigDSGEModel.CheckTransformedOptimum)>0;
   return;
end;
if abs(DSGEModel.GridWidth-OrigDSGEModel.GridWidth)>0;
   return;
end;
if abs(DSGEModel.IRHorizon-OrigDSGEModel.IRHorizon)>0;
   return;
end;
if abs(DSGEModel.PriorKernel-OrigDSGEModel.PriorKernel)>0;
   return;
end;
if abs(DSGEModel.KernelDensityValue-OrigDSGEModel.KernelDensityValue)>0;
   return;
end;
if strcmp(DSGEModel.KernelDensityEstimator,OrigDSGEModel.KernelDensityEstimator)==0;
   return;
end;
if abs(DSGEModel.PosteriorDensityValue-OrigDSGEModel.PosteriorDensityValue)>0;
   return;
end;
if abs(DSGEModel.RandomNumberValue-OrigDSGEModel.RandomNumberValue)>0;
   return;
end;
if abs(DSGEModel.MaxForecastHorizon-OrigDSGEModel.MaxForecastHorizon)>0;
   return;
end;
%if abs(DSGEModel.FreqParameterReest-OrigDSGEModel.FreqParameterReest)>0;
%   return;
%end;
if (size(DSGEModel.ShockGroupColors,1)~=size(OrigDSGEModel.ShockGroupColors,1))|(max(max(abs(DSGEModel.ShockGroupColors-OrigDSGEModel.ShockGroupColors)))>0);
   return;
end;
if (size(DSGEModel.ShockColorEnd,1)~=size(OrigDSGEModel.ShockColorEnd,1))|(max(max(abs(DSGEModel.ShockColorEnd-OrigDSGEModel.ShockColorEnd)))>0);
   return;
end;
if (size(DSGEModel.ShockColorStart,1)~=size(OrigDSGEModel.ShockColorStart,1))|(max(max(abs(DSGEModel.ShockColorStart-OrigDSGEModel.ShockColorStart)))>0);
   return;
end;
if abs(DSGEModel.BVARLags-OrigDSGEModel.BVARLags)>0;
   return;
end;
if abs(DSGEModel.HarmonicLagDecayValue-OrigDSGEModel.HarmonicLagDecayValue)>0;
   return;
end;
if abs(DSGEModel.CrossEqTightnessValue-OrigDSGEModel.CrossEqTightnessValue)>0;
   return;
end;
if abs(DSGEModel.OverallTightnessValue-OrigDSGEModel.OverallTightnessValue)>0;
   return;
end;
if abs(DSGEModel.PriorType-OrigDSGEModel.PriorType)>0;
   return;
end;
if abs(DSGEModel.PriorLevelMeanValue-OrigDSGEModel.PriorLevelMeanValue)>0;
   return;
end;
if abs(DSGEModel.PriorDiffMeanValue-OrigDSGEModel.PriorDiffMeanValue)>0;
   return;
end;
if abs(DSGEModel.OmegaPriorType-OrigDSGEModel.OmegaPriorType)>0;
   return;
end;
if abs(DSGEModel.WishartType-OrigDSGEModel.WishartType)>0;
   return;
end;
if abs(DSGEModel.VarianceTightnessValue-OrigDSGEModel.VarianceTightnessValue)>0;
   return;
end;
if abs(DSGEModel.WishartDFValue-OrigDSGEModel.WishartDFValue)>0;
   return;
end;
if strcmp(lower(DSGEModel.SteadyStatePriorFile),lower(OrigDSGEModel.SteadyStatePriorFile))==0;
   return;
end;
if (length(DSGEModel.BVARY)~=length(OrigDSGEModel.BVARY))|(sum(abs(DSGEModel.BVARY-OrigDSGEModel.BVARY))>0);
   return;
end;
if (length(DSGEModel.BVARX)~=length(OrigDSGEModel.BVARX))|(sum(abs(DSGEModel.BVARX-OrigDSGEModel.BVARX))>0);
   return;
end;
if abs(DSGEModel.NumPredPathsValue-OrigDSGEModel.NumPredPathsValue)>0;
   return;
end;
if abs(DSGEModel.PostDrawsUsageValue-OrigDSGEModel.PostDrawsUsageValue)>0;
   return;
end;
if abs(DSGEModel.RandomizeDraws-OrigDSGEModel.RandomizeDraws)>0;
   return;
end;
if max(abs(DSGEModel.ConfidenceBandBaseColor-OrigDSGEModel.ConfidenceBandBaseColor))>0;
   return;
end;
if (length(DSGEModel.ConditionalShocks)~=length(OrigDSGEModel.ConditionalShocks))|(max(abs(DSGEModel.ConditionalShocks-OrigDSGEModel.ConditionalShocks))>0);
   return;
end;
if (length(DSGEModel.ConditionalVariables)~=length(OrigDSGEModel.ConditionalVariables))|(max(abs(DSGEModel.ConditionalVariables-OrigDSGEModel.ConditionalVariables))>0);
   return;
end;
if abs(DSGEModel.PostDrawsPercentValue-OrigDSGEModel.PostDrawsPercentValue)>0;
   return;
end;
if abs(DSGEModel.InverseHessianEstimator-OrigDSGEModel.InverseHessianEstimator)>0;
   return;
end;
if abs(DSGEModel.MaxCorrelationValue-OrigDSGEModel.MaxCorrelationValue)>0;
   return;
end;
if (length(DSGEModel.ScenarioShocks)~=length(OrigDSGEModel.ScenarioShocks))|(max(abs(DSGEModel.ScenarioShocks-OrigDSGEModel.ScenarioShocks))>0);
   return;
end;
if (length(DSGEModel.ScenarioVariables)~=length(OrigDSGEModel.ScenarioVariables))|(max(abs(DSGEModel.ScenarioVariables-OrigDSGEModel.ScenarioVariables))>0);
   return;
end;
if abs(DSGEModel.ScenarioValue-OrigDSGEModel.ScenarioValue)>0;
   return;
end;
if abs(DSGEModel.AnnScenarioValue-OrigDSGEModel.AnnScenarioValue)>0;
   return;
end;
if (length(DSGEModel.ScenarioParameters)~=length(OrigDSGEModel.ScenarioParameters))|(max(abs(DSGEModel.ScenarioParameters-OrigDSGEModel.ScenarioParameters))>0);
   return;
end;
if (min(size(DSGEModel.PredictionEvent)==size(OrigDSGEModel.PredictionEvent))==0)|(min(min(DSGEModel.PredictionEvent==OrigDSGEModel.PredictionEvent))==0);
   return;
end;
if abs(DSGEModel.AdjustPredictionPaths-OrigDSGEModel.AdjustPredictionPaths)>0;
   return;
end;
if abs(DSGEModel.KsiUseCondData-OrigDSGEModel.KsiUseCondData)>0;
   return;
end;
if strcmp(lower(DSGEModel.ObsVariableScenarioFile),lower(OrigDSGEModel.ObsVariableScenarioFile))==0;
   return;
end;
if (length(DSGEModel.ParameterScenario)~=length(OrigDSGEModel.ParameterScenario))|(abs(DSGEModel.ParameterScenario-OrigDSGEModel.ParameterScenario)>0);
   return;
end;
if abs(DSGEModel.ShockControlMethod-OrigDSGEModel.ShockControlMethod)>0;
   return;
end;
if (isequal(DSGEModel.UnitRootStates,OrigDSGEModel.UnitRootStates)==0)|(length(DSGEModel.UnitRootStates)~=length(OrigDSGEModel.UnitRootStates))|(sum(abs(DSGEModel.UnitRootStates-OrigDSGEModel.UnitRootStates))>0);
   return;
end;
if abs(DSGEModel.ModifiedHessian-OrigDSGEModel.ModifiedHessian)>0;
   return;
end;
if abs(DSGEModel.AIMTolerance-OrigDSGEModel.AIMTolerance)>0;
   return;
end;
if abs(DSGEModel.AllowUnitRoot-OrigDSGEModel.AllowUnitRoot)>0;
   return;
end;
if abs(DSGEModel.ParameterScenarioValue-OrigDSGEModel.ParameterScenarioValue)>0;
   return;
end;
if abs(DSGEModel.InitializeHessian-OrigDSGEModel.InitializeHessian)>0;
   return;
end;
if strcmp(lower(DSGEModel.ParameterCovMatrix),lower(OrigDSGEModel.ParameterCovMatrix))==0;
   return;
end;
%
% there were no differences!
%
status = 1;

%
% end of CompareDSGEModel.m
%
