function About(TextStr,ImageStr,NameStr,height,width,CurrINI)
% About; Displays a dialog with text and an OK button.
%
% USAGE:
%
%       About(TextStr,ImageStr,NameStr,height,width,CurrINI)
%
% REQUIRED INPUT: TextStr (string matrix) with the text to display on the dialog.
%
%                 ImageStr (string vector) that determines which image is displayed. Valid names
%                          are "information", "question", "warning", "error". If some other
%                          string vector is given then the default logo image is chosen.
%
% OPTIONAL INPUT: NameStr (string vector) with the figure name.
%
%                 height (integer) with the dialog height in pixel units.
%
%                 width (integer) with the dialog width in pixel units.
%
%                 CurrINI (structure) with initialization information.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 25, 2006.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 11-5-2007:  Updated the documentation and fixed the close request function.
%
% * 15-5-2007:  Made the OK button 75 pixels rather than 50 pixels wide.
%
% * 9-11-2007:  Updated the documentation.
%
% * 10-1-2008:  Changed the last drawnow call to pause(0.02).
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if nargin==2;
   selector = 'init';
   NameStr = 'About';
elseif nargin==3;
   selector = 'init';
elseif nargin==4;
   selector = 'init';
elseif nargin==5;
   selector = 'init';
elseif nargin==6;
   selector = 'init';
else;
   selector = 'ok';
end;
%
if strcmp(selector,'init')==1;
   if nargin<4;
      height = 124;
   else;
      if isnumeric(height)==0;
         height = 124;
      end;
   end;
   %
   if nargin<5;
      width = 292;
   else;
      if isnumeric(width)==0;
         width = 292;
      end;
      if width<250;
         width = 250;
      end;
   end;
   %
   textheight = height-54;
   axesheight = (height-90)/2;
   if axesheight<0;
      axesheight = 0;
   end;
   %
   if nargin<6;
      CurrINI = InitializeINIFile;
   end;
   %
   % get image data
   %
   ImageStructure = ReadImages;
   %
   bgcolor = get(0,'defaultuicontrolbackgroundcolor');
   %
   if strcmp(ImageStr,'information')==1;
      mylogo = ImageStructure.allimages.information_image;
   elseif strcmp(ImageStr,'question')==1;
      mylogo = ImageStructure.allimages.question_image;
   elseif strcmp(ImageStr,'warning')==1;
      mylogo =ImageStructure.allimages.warning_image;
   elseif strcmp(ImageStr,'error')==1;
      mylogo = ImageStructure.allimages.error_image;
   else;
      mylogo = ImageStructure.allimages.logo_image;
   end;
   mylogo = MirrorImage(MakeTrans(mylogo,[160 160 164],bgcolor));
else;
   aboutdlg = get(0,'CurrentFigure');
   myabout = get(aboutdlg,'UserData');
end;
%
switch selector;
   case 'init';
      scrsz = get(0,'ScreenSize');
      aboutdlg = figure('Color',get(0,'defaultuicontrolbackgroundcolor'), ...
         'FileName','About.m', ...
         'MenuBar','none', ...
         'Units','pixels', ...
         'Position',[(scrsz(3)-width)/2 (scrsz(4)-height)/2 width height], ...
         'Tag','FigAbout', ...
         'Resize','off', ...
         'Visible','off', ...
         'Name',NameStr, ...
         'NumberTitle','off', ...
         'WindowStyle','modal', ...
         'CloseRequestFcn','About ok', ...
         'ToolBar','none');
      %
      if MatlabNumber>=7.0;
         set(aboutdlg,'DockControl','off');
      end;
      %
      % set up an axes object for the image
      %
      imageaxes = axes('Units','pixels', ...
         'Box','on', ...
         'TickLength',[0 0], ...
         'CameraUpVector',[0 1 0], ...
         'Color',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[10 50+axesheight 39 39], ...
         'XTickLabelMode','manual', ...
         'YTickLabelMode','manual', ...
         'Tag','AxisLogo', ...
         'XColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'YColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'ZColor',get(0,'defaultuicontrolbackgroundcolor'));
      %
      image('CData',mylogo,'Clipping','off','Parent',imageaxes);
      %
      % Text controls
      %
      about_txt = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[50 50 width-52 textheight], ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Style','text', ...
         'HorizontalAlignment','left', ...
         'String',' ', ...
         'Tag','Text');
      %
      % need to fix TextStr string and turn it into a cell str
      %
      [out_str,pos] = textwrap(about_txt,cellstr(TextStr));
      set(about_txt,'String',out_str,'Position',[50 50 width-52 pos(4)]);
      if max(size(out_str))==1;
         set(about_txt,'HorizontalAlignment','center');
      end;
      c_pos = 0;
      if (60+pos(4)>=90)&(height>60+pos(4));
         %
         % fix the height of the dialog
         %
         set(aboutdlg,'Position',[(scrsz(3)-width)/2 (scrsz(4)-(60+pos(4)))/2 width 60+pos(4)]);
         c_pos = 60+pos(4);
      elseif (60+pos(4)<90)&(height>60+pos(4));
         set(aboutdlg,'Position',[(scrsz(3)-width)/2 (scrsz(4)-90)/2 width 90]);
         c_pos = 90;
      end;
      if c_pos>0;
         axesheight = (c_pos-90)/2;
         set(imageaxes,'Position',[10 50+axesheight 39 39]);
      end;
      %
      % OK button
      %
      myabout.ok = uicontrol('Units','pixels', ...
         'BackgroundColor',get(0,'defaultuicontrolbackgroundcolor'), ...
         'Position',[(width-75)/2 12 75 25], ...
         'String','OK', ...
         'FontSize',CurrINI.gui_fontsize, ...
         'FontName',CurrINI.gui_fontname, ...
         'FontWeight',CurrINI.gui_fontweight, ...
         'FontAngle',CurrINI.gui_fontangle, ...
         'Enable','on', ...
         'Callback','About', ...
         'UserData','waiting', ...
         'Tag','OKButton');
      %
      set(aboutdlg,'UserData',myabout,...
         'HandleVisibility','callback');
   case 'ok'
      set(myabout.ok,'UserData','done');
      delete(aboutdlg);
      drawnow;
      pause(0.02);
end;

if strcmp(selector,'init')==1;
   %
   set(aboutdlg,'Visible','on');
   drawnow;
   if MatlabNumber>=7;
      %
      % set focus on OK button
      %
      uicontrol(myabout.ok);
   end;
   waitfor(myabout.ok,'UserData','done');
end;

%
% end of About.m
%