function status = MakeDir(BaseDir,NewDir)
%MakeDir: Makes the subdiretory NewDir in BaseDir if it doesn't already exist.
%
% USAGE:
%
%       status = MakeDir(BaseDir,NewDir)
%
% where BaseDir is the full path to the directory where NewDir should be created. If the directory exists
% then MakeDir returns 1, otherwise it attempts to create the directory. If successful in creating the NewDir
% directory, MakeDir returns 1, otherwise it returns 0.
%
% REQUIRED INPUTS: BaseDir (string) with full path (e.g. c:\code\yada)
%
%                  NewDir (string) with name of subdirectory (e.g. new-dir)
%
% REQUIRED OUTPUT: status (boolean) is 1 if NewDir exists in BaseDir or has been successfully created and 0 otherwise.
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 20, 2006.
%                        This version: December 8, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 8-12-2008:  Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

if strcmp(BaseDir(1,length(BaseDir)),'\')==0;
   TestDir = [BaseDir '\'];
else;
   TestDir = BaseDir;
end;
status = DirExist([TestDir NewDir]);
if status==0;
   CurrDir = pwd;
   cd(BaseDir);
   stat = dos(['mkdir ' NewDir]);
   status = DirExist([TestDir NewDir]);
   cd(CurrDir);
end;

%
% end of MakeDir.m
%
