function FoundFiles = GetFiles(Directory,FileExt)
% GetFiles: Collects all files with a certain file extension in a given directory.
%
% USAGE:
%
%       FoundFiles = GetFiles(Directory,FileExt)
%
% REQUIRED INPUT:  Directory (string vector) with the names of a directory.
%
%                  FileExt (string vector) with the file extension to limit the search to. If
%                          FileExt is "*" then any file extensions are considerered valid.
%
% REQUIRED OUTPUT: FoundFiles (string matrix) whose rows hold the names of the files that
%                             are located in Directory with extension FileExt.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central bank.
%
%                       First version: October 10, 2007.
%                        This version: May 23, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 30-10-2007: Updated the documentation.
%
% * 31-10-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 8-12-2008:  Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

FoundFiles = '';
if isempty(Directory)==1;
   return;
end;
Directory = StringTrim(Directory(1,:));
%
% make sure that the path doesn't end with a "\" character.
%
if (strcmp(Directory(1,length(Directory)),'\')==1)&(length(Directory)>1);
   Directory = Directory(1,1:length(Directory)-1);
end;
if DirExist(Directory)==0;
   return;
end;
%
% get directory information
%
d = dir(Directory);
for i=1:length(d);
   if (d(i).isdir==0)&((strcmp(lower(GetExt(d(i).name)),['.' FileExt])==1)|(strcmp(FileExt,'*')==1));
      FoundFiles = strvcat(FoundFiles,GetName(d(i).name));
   end;
end;

%
% end of GetFiles.m
%
