function [FileDate,FileTime] = GetFileDate(file)
% GetFileDate: Provides the date and time that a file was last saved to disk.
%
% USAGE:
%
%       [FileDate,FileTime] = GetFileDate(file)
%
% REQUIRED INPUT:  file (string vector) with the names of a file.
%
% REQUIRED OUTPUT: FileDate (string vector) with the file date written as "Month Day, Year".
%
% OPTIONAL OUTPUT: FileTime (string vector) with the file time written as "Hrs:Min:Sec".
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central bank.
%
%                       First version: January 14, 2008.
%                        This version: December 8, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 15-1-2008:  Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 30-6-2008:  Fixed a language bug giving "FileDate" too few space characters.
%
% * 8-12-2008:  Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% check if file exists
%
if FileExist(file)==0;
   FileDate = '';
   if nargout==2;
      FileTime = '';
   end;
   return;
end;
%
% get the directory info about the file
%
FileInfo = dir(file);
FileDate = FileInfo.date;
%
% change month to number
%
FileDate = strrep(FileDate,'-Jan-',' January ');
FileDate = strrep(FileDate,'-Feb-',' February ');
FileDate = strrep(FileDate,'-Mar-',' March ');
FileDate = strrep(FileDate,'-Apr-',' April ');
FileDate = strrep(FileDate,'-May-',' May ');
FileDate = strrep(FileDate,'-Jun-',' June ');
FileDate = strrep(FileDate,'-Jul-',' July ');
FileDate = strrep(FileDate,'-Aug-',' August ');
FileDate = strrep(FileDate,'-Sep-',' September ');
FileDate = strrep(FileDate,'-Oct-',' October ');
FileDate = strrep(FileDate,'-Nov-',' November ');
FileDate = strrep(FileDate,'-Dec-',' December ');
FileDate = strrep(FileDate,'-',' ');
%
% now we split the string into 4 pieces
%
FileDateMat = Str2Matrix(FileDate,' ');
if strcmp(FileDateMat(1,1),'0')==1;
   DayStr = FileDateMat(1,2:size(FileDateMat,2));
else;
   DayStr = FileDateMat(1,:);
end;
FileDate = [StringTrim(DayStr) ' ' StringTrim(FileDateMat(2,:)) ' ' StringTrim(FileDateMat(3,:))];
if nargout==2;
   FileTime = StringTrim(FileDateMat(4,:));
end;

%
% end of getfiledate.m
%
