function ModelParameters = MoreASParameters(ModelParameters)
% MoreASParameters: Shows how to define new parameters from previously defined parameters
%
% USAGE:
%
%       ModelParameters = MoreASParameters(ModelParameters)
%
% REQUIRED INPUT:  ModelParameters (structure) with fields corresponding to the parameters
%                                   you need for defining new parameters that should be
%                                   added to the structure.
%
% REQUIRED OUTPUT: ModelParameters (structure) with additions to the input structure.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: July 31, 2006.
%                        This version: January 23, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 04-08-2006: Updated function documentation while enjoying "In absentia" with Porcupine Tree!
%
% * 07-11-2007: Updated the documentation while head banging to "Universal Migrator" by Ayreon.
%
% * 09-01-2008: Updated the documentation.
%
% * 21-10-2008: Added the UserVariables field to allow the structure to pass non-parameter related
%               information.
%
% * 23-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% The parameter beta enters the inflation equation (Phillips curve) of the An-Schorfheide model. The parameter
% rA, however, is the one to be estimated. The prior is defined for this parameter in the spreadsheet "AnSchorfheide.wk1".
% When this spreadsheet is read by YADA, the field rA is specified for the ModelParameters structure.
%

ModelParameters.beta = 1/(1+(ModelParameters.rA/400));
ModelParameters.UserVariables.test = zeros(2,1);
ModelParameters.UserVariables.flag = 1;

%
% end of MoreASParameters.m
%
