function PriorMatrix = BVARSteadyStatePrior(SelectedVariables,SelectedXVariables)
% BVARSteadyStatePrior: Sets the prior parameters for the steady state parameters of a Bayesian VAR model
%
% USAGE:
%
%       PriorMatrix = BVARSteadyStatePrior(SelectedVariables)
%
% REQUIRED INPUT:  SelectedVariables (vector) with integers for selecting endogenous variables. This
%                                    input can be used if you wish to use only a subset of variables in
%                                    your Bayesian VAR. YADA supplies a variable SelectedVariables
%                                    based on the data construction file output.
%
%                  SelectedXVariables (vector) with integers for selecting exogenous variables. This input can
%                                    be used if you wish to use only a subset of some variables in
%                                    your Bayesian VAR. YADA supplies a variable SelectedXVariables
%                                    based on the data construction file output.
%
% REQUIRED OUTPUT: PriorMatrix (Nx2 matrix) where N is the number of steady state parameters of the BVAR model based
%                                    on vectorizing the matrix with steady state parameters. The first column
%                                    holds the prior mean, and the second column the prior standard deviations.
%                                    The prior distribution of the steady state parameters is normal.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: January 12, 2007.
%                        This version: January 23, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 07-11-2007: Updated the documentation.
%
% * 09-01-2008: Updated the documentation.
%
% * 23-01-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

PriorMatrix = [0.4 sqrt(0.5);6 sqrt(4);8 sqrt(5)];

%
% end of BVARSteadyStatePrior.m
%
