function lnS = logStudentTPDF(z,mu,p,q,n)
% logStudentTPDF: Calculates the height of the log of the Student t density.
%
% USAGE:
%
%       lnS = logStudentTPDF(z,mu,p,q,n)
%
% REQUIRED INPUT:  z (vector) with draws from the Student t distribution.
%
%                  mu (scalar) with the mean value of the Student t.
%
%                  p (scalar) with a value needed to compute the variance of the Student t.
%
%                  q (scalar) with a value needed to compute the variance of the Student t.
%
%                  n (integer) with the number of degrees of freedom of the Student t.
%
% REQUIRED OUTPUT: lnS (vector) with the log height of the student t at z.
%
% NOTE: The logStudentTPDF function uses the following denition of the Student t density.
%       Let b ~ t(mu,p,q,n), then for a scalar z the log of the density is
%
%          ln p(z) = c(n) + (1/2)*log(p/q) - [(2+n)/2]*log(1 + (b-mu)^2 p/q)
%
%       where
%
%          c(n) = log(Gamma((n+2)/2)) - log(Gamma((n+1)/2)) - (1/2)*log(pi)
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: February 6, 2007.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

lnS = gammaln((n+2)/2)-gammaln((n+1)/2)-((1/2)*log(pi))+((1/2)*log(sqrt(p/q)))-(((n+2)/2)*(1+(((z-mu).*(z-mu))*(p/q))));

%
% end of logStudentTPDF.m
%
