function lnN = logNormalPDF(z,mu,sigma)
% logNormalPDF: Calculates the value of the log of the normal distribution.
%
% USAGE:
%
%       lnN = logNormalPDF(z,mu,sigma)
%
% where z is a value of the random vector, while mu and sigma>0 are parameters. The output
% variable, lnN, measures the log height of the density of N(mu,sigma^2).
%
% REQUIRED INPUT:  z (vector) with values of the random variables.
%
%                  mu (vector) with means.
%
%                  sigma (vector) with standard deviations.
%
% REQUIRED OUTPUT: lnN (vector) with log density values.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 14, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 17-7-2006:  The input variables can now be vectors. NOTE: The function does not check for equality of dimensions
%
% * 19-7-2006:  Updated function information.
%
% * 25-8-2006:  Updated the documenation.
%
% * 30-11-2006: Made sure that the constant term is log(2*pi) instead of log(pi).
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

lnN = -((1/2)*log(2*pi))-log(sigma)-((1/2)*(((z-mu).*(z-mu))./(sigma.*sigma)));

%
% end of logNormalPDF.m
%
