function lnLTN = logLTNormalPDF(z,mu,sigma,c)
% logLTNormalPDF: Calculates the value of the log of the left truncated normal distribution.
%
% USAGE:
%
%       lnLTN = logLTNormalPDF(z,mu,sigma,c)
%
% where z is a vector value of the random variable, while mu and sigma>0 are the usual parameters
% of the normal distribution, while c is the vector of left truncation. The output vector, lnN,
% measures the log height of the density of LTN(mu,sigma^2,c).
%
% REQUIRED INPUT:  z (vector) with values greater than or equal to c.
%
%                  mu (vector) with mu parameters.
%
%                  sigma (vector) with sigma parameters.
%
%                  c (vector) with lower bounds for z.
%
% REQUIRED OUTPUT: lnLTN (vector) with log density values.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 14, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 17-7-2006:  Fixed the call to the normal distribution.
%
% * 19-7-2006:  Updated function information.
%
% * 25-8-2006:  Updated the documenation and made the function accept vectors.
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

lnLTN = logNormalPDF(z,mu,sigma)-log(1-PhiFunction((c-mu)./sigma));

%
% end of logLTNormalPDF.m
%
