function lnIG = logInverseGammaPDF(sigma,s,q)
% logInverseGammaPDF: Calculates the value of the log of the inverse gamma distribution.
%
% USAGE:
%
%       lnIG = logInverseGammaPDF(sigma,s,q)
%
% where sigma>0 is a value of the random vector, while q, s>0 are the parameters. The output
% vector, lnIG, measures the log height of the density of InverseGamma(q,s).
%
% The chosen parameterization of the inverse gamma is taken from
% Zellner (1971), equation (A.37b).
%
% The mode of this density for the selected parameterization is: sigma(mode) = s*sqrt(q/q+1)
%
% REQUIRED INPUT:  sigma (vector) of values greater than 0.
%
%                  s (vector) with s parameters.
%
%                  q (vector) with q parameters.
%
% REQUIRED OUTPUT: lnIG (vector) with log density values.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 14, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 17-7-2006:  The input variables can now be vectors. NOTE: The function does not check for equality of dimensions
%
% * 19-7-2006:  Updated function information.
%
% * 28-7-2006:  Reversed the order of the inputs s and q.
%
% * 25-8-2006:  Updated the documentation.
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

lnIG = log(2)-gammaln(q/2)+((q/2).*log((q.*s.*s)/2))-((q+1).*log(sigma))-((q.*s.*s)./(2*sigma.*sigma));

%
% end of logInverseGammaPDF.m
%