function [a,b] = MomentToParamGammaPDF(mu,sigma)
% MomentToParamGammaPDF: Transforms the mean and standard deviation of a Gamma distributed
%                        random variable into the a and b parameters needed for evaluating
%                        the Gamma PDF. The function assumes that mu, sigma >0.
%
% USAGE:
%
%       [a,b] = MomentToParamGammaPDF(mu,sigma)
%
% REQUIRED INPUTS:  mu (nx1) vector with the mean
%
%                   sigma (nx1) vector with the standard deviation
%
% REQUIRED OUTPUTS: a (nx1) vector with the first parameter
%
%                   b (nx1) vector with the second parameter
%
%
% NOTICE: In the univariate case, the Gamma PDF is written as:
%
%          p(z|a,b) = [1/(Gamma(a)*b^a)]*z^(a-1)*exp(-z/b)
%
%         In the multivariate case, MomentToParamGammaPDF assumes that all
%         z variables are independent.
%         
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: July 28, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

a = (mu.*mu)./(sigma.*sigma);
b = mu./a;

%
% end of MomentToParamGammaPDF.m
%
