function DTStatus = VerifyExportTransformation(VariableNames,Transformation)
% VerifyExportTransformation: Checks if the Transformation structure holds all information required to transform
%                             the data in some matrix into an export transformation
%
% USAGE:
%
%       DTStatus = VerifyExportTransformation(VariableNames,DataMatrix,Transformation)
%
% REQUIRED INPUT:  VariableNames (string matrix) with the names for the variables that should
%                                be checked if they can be transformed and inverted.
%
%                  Transformation (structure) with field names. The field name to use is determined
%                                by CurrVariable. This field name has subfields "exportfcn",
%                                "invertinitial", and "invertx".
%
% REQUIRED OUTPUT: DTStatus (boolean) that is 1 if all the transformation and invertion information is
%                                available and 0 otherwise.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: November 9, 2007.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 14-11-2007: Took into account that the field "exportx" now has the sub-fields "data" and "numinitialobs".
%
% * 20-11-2007: The sub-fields "data" and "numinitialobs" are no longer used for "exportx".
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% initialize
%
DTStatus = 0;
NumChecks = 0;
for i=1:size(VariableNames,1);
   CurrVariable = StringTrim(VariableNames(i,:));
   if isfield(Transformation,CurrVariable)==1;
      CurrField = getfield(Transformation,CurrVariable);
      %
      % check if all fields are available for CurrVariable
      %
      if (isfield(CurrField,'exportfcn')==1)&(isfield(CurrField,'exportinitial')==1)&(isfield(CurrField,'exportx')==1);
         %
         % check if the fields hold the correct types of data
         %
         if (ischar(CurrField.exportfcn)==1)&(isnumeric(CurrField.exportinitial)==1)&(isnumeric(CurrField.exportx)==1);
            NumChecks = NumChecks+1;
         else;
            break;
         end;
      else;
         break;
      end;
   else;
      break;
   end;
end;
if NumChecks==size(VariableNames,1);
   %
   % every field is specified and has the correct type of data
   %
   DTStatus = 1;
end;

%
% end of VerifyExportTransformation.m
%
