function DTStatus = VerifyDataTransformation(VariableNames,Transformation,CheckAll)
% VerifyDataTransformation: Checks if the Transformation structure holds all information required to transform
%                           the data in DataMatrix and invert this transformation.
%
% USAGE:
%
%       DTStatus = VerifyDataTransformation(VariableNames,Transformation,CheckAll)
%
% REQUIRED INPUT:  VariableNames (string matrix) with the names for the variables that should
%                                be checked if they can be transformed and inverted.
%
%                  Transformation (structure) with field names. The field name to use is determined
%                                by CurrVariable. This field name has subfields "fcn", "partial",
%                                "annualizefcn", "initial", "x", "invertfcn", "invertinitial", and
%                                "invertx".
%
%                  CheckAll (boolean) that is 1 if all fields should be checked and 0 if only
%                                the one-way transformation should be checked.
%
% REQUIRED OUTPUT: DTStatus (boolean) that is 1 if all the transformation and invertion information is
%                                available and 0 otherwise.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: October 30, 2007.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 12-11-2007: Added the input "CheckAll".
%
% * 14-11-2007: Took into account that the fields "x" and "invertx" now have sub-fields "data" and "numinitialobs".
%
% * 20-11-2007: The sub-fields "data" and "numinitialobs" are no longer used for "x" and "invertx".
%
% * 23-5-2008:  Updated the documentation.
%
% * 31-7-2008:  Added the check for the "partial" field when "CheckAll" is 1.
%
% * 12-8-2008:  Added the check for the "annualizepartial" field when "CheckAll" is 1.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% initialize
%
DTStatus = 0;
NumChecks = 0;
for i=1:size(VariableNames,1);
   CurrVariable = StringTrim(VariableNames(i,:));
   if isfield(Transformation,CurrVariable)==1;
      CurrField = getfield(Transformation,CurrVariable);
      %
      % check if all fields are available for CurrVariable
      %
      if CheckAll==1;
         if (isfield(CurrField,'fcn')==1)&(isfield(CurrField,'partial')==1)&(isfield(CurrField,'annualizefcn')==1)&(isfield(CurrField,'annualizepartial')==1)&(isfield(CurrField,'initial')==1)&(isfield(CurrField,'x')==1)&(isfield(CurrField,'invertfcn')==1)&(isfield(CurrField,'invertinitial')==1)&(isfield(CurrField,'invertx')==1);
            %
            % check if the fields hold the correct types of data
            %
            if (ischar(CurrField.fcn)==1)&(ischar(CurrField.partial)==1)&(ischar(CurrField.annualizefcn)==1)&ischar(CurrField.annualizepartial)==1&(ischar(CurrField.invertfcn)==1)&(isnumeric(CurrField.initial)==1)&(isnumeric(CurrField.x)==1)&(isnumeric(CurrField.invertinitial)==1)&(isnumeric(CurrField.invertx)==1);
               NumChecks = NumChecks+1;
            else;
               break;
            end;
         else;
            break;
         end;
      else;
         if (isfield(CurrField,'fcn')==1)&(isfield(CurrField,'annualizefcn')==1)&(isfield(CurrField,'initial')==1)&(isfield(CurrField,'x')==1);
            %
            % check if the fields hold the correct types of data
            %
            if (ischar(CurrField.fcn)==1)&(ischar(CurrField.annualizefcn)==1)&(isnumeric(CurrField.initial)==1)&(isnumeric(CurrField.x)==1);
               NumChecks = NumChecks+1;
            else;
               break;
            end;
         else;
            break;
         end;
      end;
   else;
      break;
   end;
end;
if NumChecks==size(VariableNames,1);
   %
   % every field is specified and has the correct type of data
   %
   DTStatus = 1;
end;

%
% end of VerifyDataTransformation.m
%
