function [thetaCalibrated,thetaAdditional] = ReadAdditionalParameterValues(ModelParameters,ParameterNames)
% ReadAdditionalParameterValues: Collects values of any calibrated parameters and parameters defined from other parameters
%                                into vectors.
%
% USAGE:
%
%       [thetaCalibrated,thetaAdditional] = ReadAdditionalParameterValues(ModelParameters,ParameterNames)
%
% REQUIRED INPUT:  ModelParameters (structure) with fields having the names of the inidividual parameters as they are
%                                  specified under the "model parameter" header in the file with prior distribution data.
%                                  In addition, fields located in the "update parameters file" and the "initialize
%                                  parameters file" have been added to the structure.
%
%                  ParameterNames (structure) with fields "calibrated", "beta", "gamma", "normal", "invgamma", "truncnormal",
%                                  "uniform", "all", "estimated", and "additional". Each field returns a string matrix with
%                                  the parameter names.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 14, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 18-8-2006:  Changed the StrTrim function to StringTrim.
%
% * 14-9-2006:  Changed ModelParameter to Modelparameters on line 46. Bug discovered by Kai Christoffel.
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

thetaCalibrated = [];
thetaAdditional = [];
if isempty(ParameterNames.calibrated)==0;
   for i=1:size(ParameterNames.calibrated,1);
      thetaCalibrated = [thetaCalibrated;getfield(ModelParameters,StringTrim(ParameterNames.calibrated(i,:)))];
   end;
end;
if isempty(ParameterNames.additional)==0;
   for i=1:size(ParameterNames.additional,1);
      thetaAdditional = [thetaAdditional;getfield(ModelParameters,StringTrim(ParameterNames.additional(i,:)))];
   end;
end;

%
% end of ReadAdditionalParameterValues.m
%
