function ModelFiles = ReOrderModelFiles(ModelFiles,NewModelFile)
% ReOrderModelFiles: Reorders the string matrix with DSGE model files
%
% USAGE:
%
%       ModelFiles = ReOrderModelFiles(ModelFiles,NewModelFile)
%
% REQUIRED INPUT:  ModelFiles (string matrix) where each row gives the full path
%                             and name of a model file.
%
%                  NewModelFile (string vector) with full path and name of a newly
%                             considered model file.
%
% REQUIRED OUTPUT: ModelFiles (string matrix) where each row gives the full path
%                             and name of a model file.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: Januart 24, 2007.
%                        This version: December 19, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 19-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% some preliminary checks of the new fil
%
if FileExist(NewModelFile)==0;
   return;
end;
if strcmp(lower(GetExt(NewModelFile)),'.dsge')==0;
   return;
end;
%
% check if the file already exists
%
IsNewFile = 1;
for i=1:size(ModelFiles,1);
   if strcmp(lower(StringTrim(ModelFiles(i,:))),lower(NewModelFile))==1;
      IsNewFile = 0;
      break;
   end;
end;
if IsNewFile==0;
   %
   % the file is already included in the ModelFile list
   %
   return;
end;
%
% we have a new file
%
ModelFiles = strvcat(NewModelFile,ModelFiles);
if size(ModelFiles,1)>10;
   ModelFiles = ModelFiles(1:10,:);
end;

%
% end of ReOrderModelFiles.m
%
