function DateVector = MakeDateVector(StartYear,StartPeriod,EndYear,EndPeriod,Frequency)
% MakeDateVector: Creates a vector of dates based on sample information.
%
% USAGE:
%
%       DateVector = MakeDateVector(StartYear,StartPeriod,EndYear,EndPeriod,Frequency)
%
% REQUIRED INPUT:  StartYear (string vector) with the sample start year.
%
%                  StartPeriod (string vector) with the sample start period.
%
%                  EndYear (string vector) with the sample end year.
%
%                  EndPeriod (string vector) with the sample end period.
%
%                  Frequency (string vector) with the sample frequency. Can be one of the
%                            following: "q" (quarterly), "m" (monthly, "a" (annual)
%
% REQUIRED OUTPUT: DateVector (1xT) vector with date numbers. Notice that center points
%                            are used . Hence, 1980Q1 = 1980+(1/8); 1980m1 = 1980+(1/24).
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 18, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

sy = str2num(StartYear);
sp = str2num(StartPeriod);
ey = str2num(EndYear);
ep = str2num(EndPeriod);
if strcmp(lower(Frequency(1,1)),'q')==1;
   fp = sy+(sp/4)-(1/8);
   lp = ey+(ep/4)-(1/8);
   pd = 1/4;
elseif strcmp(lower(Frequency(1,1)),'m')==1;
   fp = sy+(sp/12)-(1/24);
   lp = ey+(ep/12)-(1/24);
   pd = 1/12;
else;
   fp = sy;
   lp = ey;
   pd = 1;
end;
DateVector = (fp:pd:lp);

%
% end of MakeDateVector.m
%
