function [ExportNames,ExportTitles] = GetExportNames(VariableNames,Transformation)
% GetExportNames: Checks if the user has provided exporttitle and exportname in the Transformation for all variables
%
% USAGE:
%
%       [ExportNames,ExportTitles] = GetExportNames(VariableNames,Transformation)
%
% REQUIRED INPUT:  VariableNames (string matrix) with the names of all the variables.
%
%                  Transformation (structure) with field names. The field name to use is determined
%                                 by CurrVariable. This field names that we look for are "exporttitle"
%                                 and "exportname".
%
% REQUIRED OUTPUT: ExportNames (string matrix) with alternative names for the variables.
%
%                  ExportTitles (string matrix) with titles for the variables.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: January 25, 2008.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 28-3-2008:  Added the "ExportTitles" output.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% initialize
%
ExportNames = VariableNames;
ExportTitles = '';
n = size(VariableNames,1);
NewExportNames = '';
for i=1:n;
   CurrVariable = StringTrim(VariableNames(i,:));
   if isfield(Transformation,CurrVariable)==1;
      CurrField = getfield(Transformation,CurrVariable);
      if isfield(CurrField,'exportname')==1;
         ExName = CurrField.exportname;
         if (ischar(ExName)==1)&(isempty(ExName)==0);
            NewExportNames = strvcat(NewExportNames,ExName);
            if i==n;
               %
               % all check for all variables were successful
               %
               ExportNames = NewExportNames;
            end;
         else;
            break;
         end;
      else;
         break;
      end;
      if isfield(CurrField,'exporttitle')==1;
         ExTitle = CurrField.exporttitle;
         if (ischar(ExTitle)==1)&(isempty(ExTitle)==0);
            ExportTitles = strvcat(ExportTitles,ExTitle);
         end;
      end;
   else;
      break;
   end;
end;
%
% make sure that ExportTitles has the same number of rows as ExportNames
%
if size(ExportTitles,1)<size(ExportNames);
   ExportTitles = char(zeros(n,1));
end;

%
% end of GetExportNames.m
%
