function ParameterValues = CheckBounds(ParameterValues,ParameterBounds)
% CheckBounds: Checks if the parameters satisfy the specified bound. If not, the parameters are adjusted
%              to make sure that they satisfy the closest bound.
%
% USAGE:
%
%       ParameterValues = CheckBounds(ParameterValues,ParameterBounds)
%
% REQUIRED INPUT:  ParameterValues (vector) with parameter values.
%
%                  ParameterBounds (matrix) with lower and upper bounds for the parameters in the first
%                                  and in the second column, respectively, while the third column provides
%                                  and indicator it 0, 1, or 2 bounds are binding. If 1, then only the lower
%                                  bound is binding.
%
% REQUIRED OUTPUT: ParameterValues (vector) with parameter values that satisfy the bounds.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: October 26, 2007.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 30-10-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

for i=1:length(ParameterValues);
   if ParameterBounds(i,3)==0;
      if (ParameterValues(i)<=ParameterBounds(i,1));
         ParameterValues(i) = ParameterBounds(i,1)+1e-10;
      elseif (ParameterValues(i)>=ParameterBounds(i,2));
         ParameterValues(i) = ParameterBounds(i,2)-1e-10;
      end;
   elseif ParameterBounds(i,3)==1;
      if (ParameterValues(i)<ParameterBounds(i,1));
         ParameterValues(i) = ParameterBounds(i,1);
      elseif (ParameterValues(i)>=ParameterBounds(i,2));
         ParameterValues(i) = ParameterBounds(i,2)-1e-10;
      end;
   elseif ParameterBounds(i,3)==2;
      if (ParameterValues(i)<ParameterBounds(i,1));
         ParameterValues(i) = ParameterBounds(i,1);
      elseif (ParameterValues(i)>ParameterBounds(i,2));
         ParameterValues(i) = ParameterBounds(i,2);
      end;
   end;
end;

%
% end of CheckBounds.m
%
