function Transformation = ChangeTransformExogenous(Transformation,VariableNames,XValues)
% ChangeTransformExogenous: Changes the exogenous values for the variable dependent transformation functions.
%
% USAGE:
%
%       Transformation = ChangeTransformExogenous(Transformation,VariableNames,XValues)
%
% REQUIRED INPUT:  Transformation (structure) with field names. The field name to use is determined
%                                 by CurrVariable. This field name has subfields "fcn", "annualizefcn",
%                                 "initial", "x", "invertfcn", "invertinitial", and "invertx".
%
%                  VariableNames (string matrix) of dimension kxK with the names of the variables.
%
%                  XValues (matrix) of dimension kxT with the additional x-values for the individual
%                                 variables.
%
% REQUIRED OUTPUT: Transformation (structure) with field names. The field name to use is determined
%                                 by CurrVariable. This field name has subfields "fcn", "annualizefcn",
%                                 "initial", "x", "invertfcn", "invertinitial", and "invertx".
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: August 8, 2008.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 28-8-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

[k,T] = size(XValues);
for i=1:k;
   CurrVariable = StringTrim(VariableNames(i,:));
   CurrField = getfield(Transformation,CurrVariable);
   XVals = XValues(i,:)';
   %
   % Add XVals to the end of CurrField.x
   %
   if isempty(CurrField.x)==1;
      CurrField.x = XVals;
   else;
      if size(CurrField.x,1)==length(XVals);
         CurrField.x = [CurrField.x XVals];
      elseif size(CurrField.x,2)==length(XVals);
         CurrField.x = [CurrField.x' XVals];
      end;
   end;
   Transformation = setfield(Transformation,CurrVariable,CurrField);
end;

%
% end of ChangeTransformExogenous.m
%
