function [NewStartYear,NewStartPeriod] = AdjustSampleStart(StartYear,StartPeriod,Frequency,AddPeriod)
% AdjustSampleStart: Creates a vector of dates based on sample information.
%
% USAGE:
%
%       [NewStartYear,NewStartPeriod] = AdjustSampleStart(StartYear,StartPeriod,Frequency,AddPeriod)
%
% REQUIRED INPUT:  StartYear (string vector) with the start year.
%
%                  StartPeriod (string vector) with the start period.
%
%                  Frequency (string vector) with the data frequency. Can be one of the
%                            following: "q" (quarterly), "m" (monthly, "a" (annual)
%
%                  AddPeriod (integer) with the number of periods to add to the period
%                            StartYear StartPeriod. For instance, if StartYear='1981' and
%                            StartPeriod='2' for Frequency='q' with AddPeriod=3, then
%                            NewStartYear = '1982' and NewStartPeriod='1'.
%
% REQUIRED OUTPUT: NewStartYear (string vector) with the new start year.
%
%                  NewStartPeriod (string vector) with the new start period.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: November 9, 2006.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

NewStartYear = '';
NewStartPeriod = '';
AddPeriod = round(AddPeriod);
if isequal(AddPeriod,0)==1;
   NewStartYear = StartYear;
   NewStartPeriod = StartPeriod;
   return;
end;
%
sy = str2num(StartYear);
sp = str2num(StartPeriod);
if strcmp(lower(Frequency(1,1)),'q')==1;
   sp = sp+1;
   DateNum = (sy+(sp/4)-(1/8));
   for i=2:AddPeriod;
      DateNum = DateNum+(1/4);
   end;
   NewStartYear = num2str(floor(DateNum));
   NewStartPeriod = num2str((4*(DateNum-floor(DateNum))+(1/2)));
elseif strcmp(lower(Frequency(1,1)),'m')==1;
   sp = sp+1;
   DateNum = sy+(sp/12)-(1/24);
   for i=2:AddPeriod;
      DateNum = DateNum+(1/12);
   end;
   NewStartYear = num2str(floor(DateNum));
   NewStartPeriod = num2str((12*(DateNum-floor(DateNum))+(1/2)));
else;
   NewStartYear = num2str(sy+AddPeriod);
   NewStartPeriod = StartPeriod;
end;

%
% end of AdjustSampleStart.m
%
