function status = BVARPredictionsExist(OutputDirectory,NameOfModel,PriorType,OmegaPriorType,h,NumDraws,NumPaths,AnnualizeData)
% BVARPredictionsExist: Tests is all the results for the predictive distributions exist on disk.
%
% USAGE:
%
%       status = BVARPredictionsExist(OutputDirectory,NameOfModel,PriorType,OmegaPriorType,h,NumDraws,NumPaths,AnnualizeData)
%
% REQUIRED INPUT:  OutputDirectory (string vector) with the full path to the base output directory.
%
%                  NameOfModel (string vector) with the name of the model.
%
%                  PriorType (integer) determining the type of prior used for the parameters on lagged endogenous
%                            variables of the Bayesian VAR. The value "1" is the Minnesota-style prior, "2" is the
%                            normal conditional on the covariance matrix prior, and "3" the diffuse prior.
%
%                  OmegaPriorType (integer) determining the type of prior used for the covariance matrix parameters.
%                            The value "1" is a diffuse prior, and "2" and inverse Wishart prior.
%
%                  h (integer) with the length of the prediction horizon.
%
%                  NumDraws (integer) with the total number of parameter draws.
%
%                  NumPaths (integer) with tht total number of prediction paths per parameter draw.
%
%                  AnnualizeData (boolean) that take the value 1 if annualized results should be checked and 0 otherwise.
%
% REQUIRED OUTPUT: status (boolean) that is 1 if the results exist on disk and 0 otherwise.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2008 European Central Bank.
%
%                       First version: May 10, 2007.
%                        This version: December 18, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 13-11-2007: Updated the documentation.
%
% * 23-5-2008:  Updated the documentation.
%
% * 18-12-2008: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

status = 0;
for ParamIndex=1:NumDraws;
   if AnnualizeData==0;
      file = [OutputDirectory '\predictions\BVAR-Prediction-Original-' NameOfModel '-' num2str(PriorType,'%0.0f') '.' num2str(OmegaPriorType,'%0.0f') '-' num2str(h,'%0.0f') '-' num2str(ParamIndex,'%0.0f') '.' num2str(NumDraws,'%0.0f') '.' num2str(NumPaths,'%0.0f') '.mat'];
   else;
      file = [OutputDirectory '\predictions\BVAR-Prediction-Annual-' NameOfModel '-' num2str(PriorType,'%0.0f') '.' num2str(OmegaPriorType,'%0.0f') '-' num2str(h,'%0.0f') '-' num2str(ParamIndex,'%0.0f') '.' num2str(NumDraws,'%0.0f') '.' num2str(NumPaths,'%0.0f') '.mat'];
   end;
   if FileExist(file)==0;
      return;
   end;
end;
status = 1;

%
% end of BVARPredictionsExist.m
%
