function [nonsing,b] = AiMReducedForm(q,qrows,qcols,bcols,neq,b,condn);
% AiMReducedForm: Compute reduced-form coefficient matrix, b.
%
% USAGE:
%
%       [nonsing,b] = AiMReducedForm(q,qrows,qcols,bcols,neq,b,condn);
%
% REQUIRED INPUT:  q (matrix) of dimenion qrowsxqcols where the leftmost part should be
%                    multiplied by the inverse of the rightmost part for obtaining the
%                    reduced form.
%
%                  qrows (integer) with the number of rows (=neq*nlead) of q.
%
%                  qcols (integer) with the number of columns (=neq*(nlag+nlead)) of q.
%
%                  bcols (integer) with the number of columns (=neq*nlag) of b.
%
%                  neq (integer) with the number of equations.
%
%                  b (matrix) of dimension neqxbcols with the reduced form parameters.
%
%                  condn (positive scalar) indicating numerical tolerance.
%
% REQUIRED OUTPUT: nonsing (boolean) that indicates if q(:right) is non-singular or not.
%
%                  b (matrix) of dimension neqxbcols with the reduced form parameters.
%
% NOTE: This function is based on aim_reduced_form.m
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 25, 2006.
%                        This version: March 3, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-05-2008: Added the cond test as well as updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 05-12-2008: Updated the documentation.
%
% * 03-03-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

left = 1:qcols-qrows;
right = qcols-qrows+1:qcols;
nonsing = rcond(q(:,right))>condn;
if nonsing==0;
   %
   % try the cond function instead.
   %
   nonsing = cond(q(:,right))>condn;
end;
%
if nonsing==1;
   q(:,left) = -q(:,right)\q(:,left);
end;
b = q(1:neq,1:bcols);

%
% end of AiMReducedForm.m
%
