function scof = AiMObservedStructure(cof,cofb,neq,nlag,nlead)
% AiMObservedStructure: Construct the coefficients in the observable structure.
%
% USAGE:
%
%       scof = AiMObservedStructure(cof,cofb,neq,nlag,nlead)
%
% REQUIRED INPUT:  cof (matrix), with structural coefficients.
%
%                  neq (integer), with the number of equations.
%
%                  nlag (integer), with the number of lags.
%
%                  nlead (integer), with the number of leads.
%
% REQUIRED OUTPUT: scof (matrix) with the observable structural coefficients.
% 
%    
% NOTE: This function is based on obstruct.m
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 25, 2006.
%                        This version: March 3, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 30-10-2007: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 05-12-2008: Updated the documentation.
%
% * 03-03-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

%
% Append the negative identity to cofb
%
cofb = [cofb, -eye(neq)];
%
scof = zeros(neq,neq*(nlag+1));
q    = zeros(neq*nlead,neq*(nlag+nlead));
%
[rc,cc] = size(cofb);
q(1:rc,1:cc) = cofb;
qcols = neq*(nlag+nlead);
%
if (nlead>1); 
   for i=1:nlead-1;
      rows = i*neq + (1:neq);
      q(rows,:) = AiMShiftRight(q((rows-neq),:),neq);
   end;
end;
%
l = (1:neq*nlag);
r = (neq*nlag+1: neq*(nlag+nlead));
%
q(:,l) = - q(:,r) \ q(:,l);
%
minus =              1:       neq*(nlag+1);
plus  = neq*(nlag+1)+1: neq*(nlag+1+nlead);
%
scof(:,neq+1:neq*(nlag+1)) = cof(:,plus)*q(:,l);
scof = scof + cof(:,minus);

%
% end of AiMObservedStructure.m
%
