function [h,q,iq,nexact] = AiMExactShift(h,q,iq,qrows,qcols,neq)
% AiMExactShift: Compute the exact shiftrights and store them in q.
%
% USAGE:
%
%       [h,q,iq,nexact] = AiMExactShift(h,q,iq,qrows,qcols,neq)
%
% REQUIRED INPUT:  h (matrix) with structural coefficients - dimension (neq,neq*(nlag+1+nlead)).
%
%                  q (matrix) with previous shiftrights (zero-matrix in YADA).
%
%                  iq (integer) with the number of previous shiftrights (0 in YADA).
%
%                  qrows (integer) with the number of rows (=neq*nlead) of q.
%
%                  qcols (integer) with the number of columns (=neq*(nlag+nlead)) of q.
%
%                  neq (integer) with the number of equations.
%
% REQUIRED OUTPUT: h (matrix) with structural coefficients - dimension (neq,neq*(nlag+1+nlead)).
%
%                  q (matrix) with all shiftrights (same as all exact shiftrights in YADA).
%
%                  iq (integer) with the total number of shiftrights.
%
%                  nexact (integer) with the number of exact shiftrights.
%
% NOTE: This function is based on aim_exact_shift.m
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 25, 2006.
%                        This version: March 3, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-05-2008: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 05-12-2008: Updated the documentation.
%
% * 03-03-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% initialize
%
nexact = 0;
left   = 1:qcols;
right  = qcols+1:qcols+neq;
%
zerorows = find(sum(abs(h(:,right)'))==0);
%
while (any(zerorows)&iq<=qrows);
   %
   nz = length(zerorows);
   %
   q(iq+1:iq+nz,:) = h(zerorows,left);
   h(zerorows,:)   = AiMShiftRight(h(zerorows,:),neq);
   %
   iq     = iq + nz;
   nexact = nexact + nz;
   %
   zerorows = find(sum(abs(h(:,right)'))==0);
end;

%
% end of AiMExactShift.m
%
