function [w,rts,lgroots] = AiMEigenSystem(a,uprbnd) 
% AiMEigenSystem: Compute the roots and the left eigenvectors of the companion
%                 matrix, sort the roots from large-to-small, and sort the
%                 eigenvectors conformably.  Map the eigenvectors into the real
%                 domain. Count the roots bigger than uprbnd.
%
% USAGE:
%
%       [w,rts,lgroots] = AiMEigenSystem(a,uprbnd)
%
% REQUIRED INPUT:  a (matrix) with the companion matrix for computing the non-zero eigenvalues.
%
%                  uprbdn (real) with the upper bound for a unit root.
%
% REQUIRED OUTPUT: w (matrix) with the eigenvectors of a.
%
%                  rts (vector) with the sorted eigenvalues of a.
%
%                  lgroots (integer) wioth the number of roots greater than unity.
%
% NOTE: This function is based on aim_eigensystem.m
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 25, 2006.
%                        This version: March 3, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-05-2008: Updated the documentation.
%
% * 23-05-2008: Updated the documnetation.
%
% * 05-12-2008: Updated the documentation.
%
% * 03-03-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[w,d]   = eig(a');
rts     = diag(d);
mag     = abs(rts);
[mag,k] = sort(-mag);
rts     = rts(k);
w       = w(:,k);
%
%  Given a complex conjugate pair of vectors W = [w1,w2], there is a
%  nonsingular matrix D such that W*D = real(W) + imag(W).  That is to
%  say, W and real(W)+imag(W) span the same subspace, which is all
%  that aim cares about. 
%
w = real(w) + imag(w);
lgroots = sum(abs(rts)>uprbnd);

%
% end of AiMEigenSystem.m
%
