function  q = AiMCopyEigenvectors(q,w,js,iq,qrows)
% AiMCopyEigenvectors: Copy the eigenvectors corresponding to the largest roots into the
%                      remaining empty rows and columns js of q.
%
% USAGE:
%
%       q = AiMCopyEigenvectors(q,w,js,iq,qrows)
%
% REQUIRED INPUT:  q (matrix) with all shiftrights.
%
%                  w (matrix) with the eigenvectors of a, the companion matrix of h, the matrix
%                    with structural coefficients.
%
%                  js (vector) with the columns of the transition matrix with the essential
%                    lags.
%
%                  iq (integer) with the total number of shiftrights.
%
%                  qrows (integer) with the number of rows (=neq*nlead) of q.
%
% REQUIRED OUTPUT: q (matrix) with all shiftrights and where the eigenvectors of a are filled in.
%
% NOTE: This function is based on aim_copy_w.m
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: August 25, 2006.
%                        This version: March 3, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 19-05-2008: Updated the documentation.
%
% * 23-05-2008: Updated the documentation.
%
% * 05-12-2008: Updated the documentation.
%
% * 03-03-2009: Updated the documentation.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if (iq<qrows);
   lastrows = iq+1:qrows;
   wrows    = 1:length(lastrows);
   %
   q(lastrows,js) = w(:,wrows)';
end;

%
% end of AiMCopyEigenvectors.m
%
