function [VersionOfYADA,VersionDateStr] = YADAVersion
% YADAVersion: provides the current version number of YADA
%
% USAGE:
%
%       [VersionOfYADA,VersionDateStr] = YADAVersion
%
% REQUIRED OUTPUT: VersionOfYADA (integer) with the current version number of YADA.
%
% OPTIONAL OUTPUT: VersionDateStr (string vector) with the date when the YADAGUI was last
%                                 edited.
%
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: July 25, 2006.
%                        This version: January 5, 2009.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 14-1-2008:  Added the output argument "VersionDateStr".
%
% * 23-5-2008:  Updated the documentation.
%
% * 27-6-2008:  Changed the version number from 1.00 to 1.10.
%
% * 25-8-2008:  Changed the version number from 1.10 to 1.20.
%
% * 16-9-2008:  Changed the version number from 1.20 to 1.30.
%
% * 22-9-2008:  Changed the version number from 1.30 to 1.40.
%
% * 1-12-2008:  Changed the version number from 1.40 to 1.50.
%
% * 5-12-2008:  Updated the documentation.
%
% * 05-01-2009: Changed the version number from 1.50 to 1.60.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%

VersionOfYADA = 1.60;
if nargout==2;
   VersionDateStr = GetFileDate([pwd '\YADAGUI.m']);
end;

%
% end of YADAVersion.m
%
