function ProgPath = YADAPath
% YADAPath: Sets the matlab path such that all directories with YADA related files can be located.
%
% USAGE:
%
%       ProgPath = YADAPath
%
% The function takes no inputs and returns the path as outputs if asked for. Should only be called once per matlab session.
% This is handled internally by YADA and the user need therefore not bother.
%
% OPTIONAL OUTPUT: ProgPath
%
%                       Written by: Anders Warne
%                                   New Area Wide Model Project
%                                   DG-R/EMO
%                                   European Central Bank (ECB)
%                                   Email: anders.warne@ecb.europa.eu
%                                   Copyright  2006-2009 European Central Bank.
%
%                       First version: July 17, 2006.
%                        This version: March 2, 2008.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% LICENSE INFORMATION:
%
%      YADA is free software: you can redistribute it and/or modify
%      it under the terms of the GNU General Public License as published by
%      the Free Software Foundation, either version 3 of the License, or
%      (at your option) any later version.
%
%      This program is distributed in the hope that it will be useful,
%      but WITHOUT ANY WARRANTY; without even the implied warranty of
%      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%      GNU General Public License for more details.
%
%      You should have received a copy of the GNU General Public License
%      along with this program.  If not, see <http://www.gnu.org/licenses/>.
%
%      YADA is released under the GNU General Public License, Version 3,
%      29 June 2007 <http://www.gnu.org/licenses/>. The current release of
%      the program was last modified by the ECB on the "This version" date
%      above.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% CHANGELOG:
%
% * 18-07-2006: Added aim paths.
%
% * 20-07-2006: Removed redundant aim paths. The original path used by YADA is now returned if the call has an output
%               argument.
%
% * 21-07-2006: Added GUI related paths.
%
% * 27-07-2006: Added tmp path and it's creation if necessary.
%
% * 08-08-2006: Added the optim\csminwel and posterior paths.
%
% * 10-08-2006: Added the optim\fmin\matlab7, optim\fmin\matlab5, and optim\general paths.
%
% * 11-08-2006: Added the optim\fmin\matlab7\optimlib, gui\graphics, and print paths.
%
% * 14-08-2006: Added the tools path.
%
% * 28-08-2006: Added the rndfcn and rndfcn\stats paths. The latter is only added if the
%               betarnd function is unavailable.
%
% * 29-08-2006: Added the gui\kdest directory to path.
%
% * 30-08-2006: Added the montecarlo directory to path.
%
% * 08-11-2006: Added the directories algorithms\control\matlab5 and algorithms\control\matlab7 to path
%
% * 09-11-2006: The directory rndfcn\stats is always added to path.
%
% * 15-12-2006: Added the directory gui\densityest.
%
% * 11-01-2007: Added the directory bvar.
%
% * 02-11-2007: Updated the documentation.
%
% * 18-03-2008: Added the sub-directories "addons\ovs", "addons\sss", and "addons\wz" to the path.
%
% * 23-05-2008: Updated the documentation.
%
% * 10-07-2008: Added matlab75 directory to path for the optimization functions.
%
% * 14-07-2008: Added checks for the existence of "YADAfminuncx.m" (where x is 5 0r 7).
%
% * 21-07-2008: Added check for the existence of "YADAbetarnd".
%
% * 27-07-2008: Fixed "FileExist" check errors for "YADAdare".
%
% * 28-11-2008: Updated the documentation.
%
% * 05-12-2008: Updated the documentation.
%
% * 05-01-2009: Updated the documentation.
%
% * 02-03-2009: Added additional file checks for fminunc related files.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% prepend the paths containing YADA related files to the search path for Matlab
%
path([pwd '\aim'],path);
path([pwd '\aim\aimprocs'],path);
path([pwd '\algorithms'],path);
path([pwd '\bvar'],path);
path([pwd '\data'],path);
path([pwd '\dist'],path);
path([pwd '\filesystem'],path);
path([pwd '\filter'],path);
path([pwd '\gui'],path);
path([pwd '\gui\densityest'],path);
path([pwd '\gui\initialize'],path);
path([pwd '\gui\graphics'],path);
path([pwd '\gui\kdest'],path);
path([pwd '\logic'],path);
path([pwd '\math'],path);
path([pwd '\misc'],path);
path([pwd '\montecarlo'],path);
path([pwd '\optim\csminwel'],path);
path([pwd '\optim\general'],path);
if (MatlabNumber>=7)&(MatlabNumber<7.5);
   if FileExist([pwd '\optim\fmin\matlab7\YADAfminunc7.m'])==1;
      path([pwd '\optim\fmin\matlab7'],path);
      path([pwd '\optim\fmin\matlab7\optimlib'],path);
   elseif FileExist([pwd '\optim\fmin\matlab75\YADAfminunc7.m'])==1;
      path([pwd '\optim\fmin\matlab75'],path);
      path([pwd '\optim\fmin\matlab75\optimlib'],path);
   end;
   if FileExist([pwd '\algorithms\control\matlab7\YADAdare.m'])==1;
      path([pwd '\algorithms\control\matlab7'],path);
   end;
elseif MatlabNumber>=7.5;
   if FileExist([pwd '\optim\fmin\matlab75\YADAfminunc7.m'])==1;
      path([pwd '\optim\fmin\matlab75'],path);
      path([pwd '\optim\fmin\matlab75\optimlib'],path);
   elseif FileExist([pwd '\optim\fmin\matlab7\YADAfminunc7.m'])==1;
      path([pwd '\optim\fmin\matlab7'],path);
      path([pwd '\optim\fmin\matlab7\optimlib'],path);
   end;
   if FileExist([pwd '\algorithms\control\matlab7\YADAdare.m'])==1;
      path([pwd '\algorithms\control\matlab7'],path);
   end;
else;
   if FileExist([pwd '\optim\fmin\matlab5\YADAfminunc5.m'])==1;
      path([pwd '\optim\fmin\matlab5'],path);
   elseif FileExist([pwd '\optim\fmin\matlab7\YADAfminunc7.m'])==1;
      path([pwd '\optim\fmin\matlab7'],path);
      path([pwd '\optim\fmin\matlab7\optimlib'],path);
   end;
   if FileExist([pwd '\algorithms\control\matlab5\YADAdare.m'])==1;
      path([pwd '\algorithms\control\matlab5'],path);
   end;
end;
path([pwd '\posterior'],path);
path([pwd '\print'],path);
path([pwd '\rndfcn'],path);
if FileExist([pwd '\rndfcn\stats\YADAbetarnd.m'])==1
   path([pwd '\rndfcn\stats'],path);
end;
path([pwd '\strfun'],path);
path([pwd '\tools'],path);
%
if FileExist([pwd '\addons\ovs\CheckScenarioData.m'])==1;
   path([pwd '\addons\ovs'],path);
end;
if FileExist([pwd '\addons\sss\DSGEShockScenarios.m'])==1;
   path([pwd '\addons\sss'],path);
end;
if FileExist([pwd '\addons\wz\DSGECondPredictionPathsWZ.m'])==1;
   path([pwd '\addons\wz'],path);
end;
%
% create the tmp directory under pwd if it doesn't already exist
%
if DirExist([pwd '\tmp'])==0;
   stat = MakeDir(pwd,'tmp');
end;
path([pwd '\tmp'],path);
%
% Return the current path
%
if nargout==1;
   ProgPath = path;
end;

%
% end of YADAPath.m
%
