#-------------------------------------------------------------------------------
#
# buildELF.tcl
#
# batch.build debug and release FW of the CDI2 Device Core
#
#     $ xsct buildELF.tcl
#
# (c)2023 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

# set Vitis workspace
setws Workspace.build

# import platform (Mars_ZX2_ST3), library (OpenPowerLink), and application (CDI2_Device)
importprojects Workspace.build

# generate platform
platform active Mars_ZX2_ST3
platform clean
platform generate

# build Debug and Release variants of the OpenPowerLink library
library config -name OpenPowerLink build-config Debug
library build OpenPowerLink

library config -name OpenPowerLink build-config Release
library build OpenPowerLink

# build Debug and Release variants of the CDI2_Device application
app config -name CDI2_Device build-config Debug
app build CDI2_Device

app config -name CDI2_Device build-config Release
app build CDI2_Device
