#-------------------------------------------------------------------------------
#
# buildBIT.tcl
#
# batch build bitstream and HW platform for the CDI2 Device Core
#
#     $ vivado -mode batch -source scripts/buildBIT.tcl Mars_ZX2_ST3/Mars_ZX2_ST3.xpr
#
# (c)2023 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

# synthesize design
catch { launch_runs synth_1
        wait_on_runs synth_1 }
open_run synth_1

# implement (place and route) design
catch { launch_runs impl_1
        wait_on_runs impl_1 }
open_run impl_1

# write bitstream
write_bitstream -force [file join [get_property DIRECTORY [get_run impl_1]] Mars_ZX2_ST3.bit]

# write MMI file
write_mem_info -force [file join [get_property DIRECTORY [get_run impl_1]] Mars_ZX2_ST3.mmi]

# write HW platform file
write_hw_platform -fixed -include_bit -force Mars_ZX2_ST3.xsa

