/**
********************************************************************************
\file   stubs.c

\brief  Stubs for event module unit tests

This file contains all stubs needed by the unit tests of the event module.

*******************************************************************************/

/*------------------------------------------------------------------------------
Copyright (c) 2012, B&R Industrial Automation GmbH
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
------------------------------------------------------------------------------*/

//------------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------------
#include <oplk/oplkinc.h>
#include <oplk/event.h>

//============================================================================//
//            G L O B A L   D E F I N I T I O N S                             //
//============================================================================//

//------------------------------------------------------------------------------
// const defines
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// module global vars
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// global function prototypes
//------------------------------------------------------------------------------


//============================================================================//
//            P R I V A T E   D E F I N I T I O N S                           //
//============================================================================//

//------------------------------------------------------------------------------
// const defines
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// local types
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// local function prototypes
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// local vars
//------------------------------------------------------------------------------

//============================================================================//
//            P U B L I C   F U N C T I O N S                                 //
//============================================================================//

void  target_enableGlobalInterrupt(BYTE fEnable_p)
{
    UNUSED_PARAMETER(fEnable_p);
}

tOplkError nmtk_process(const tEvent* pEvent_p)
{
    UNUSED_PARAMETER(pEvent_p);
    return kErrorOk;
}

tOplkError dllk_process(const tEvent* pEvent_p)
{
    UNUSED_PARAMETER(pEvent_p);
    return kErrorOk;
}

tOplkError dllkcal_process(const tEvent* pEvent_p)
{
    UNUSED_PARAMETER(pEvent_p);
    return kErrorOk;
}

tOplkError errhndk_process(const tEvent* pEvent_p)
{
    UNUSED_PARAMETER(pEvent_p);
    return kErrorOk;
}

tOplkError pdokcal_process(const tEvent* pEvent_p)
{
    UNUSED_PARAMETER(pEvent_p);
    return kErrorOk;
}

tOplkError eventkcal_postUserEvent(const tEvent* pEvent_p)
{
    UNUSED_PARAMETER(pEvent_p);
    return kErrorOk;
}

tOplkError eventkcal_postKernelEvent(const tEvent* pEvent_p)
{
    UNUSED_PARAMETER(pEvent_p);
    return kErrorOk;
}

//============================================================================//
//            P R I V A T E   F U N C T I O N S                               //
//============================================================================//

