/**
 * @file targetsection.h
 * @brief link functions into specific memory sections
 *
 * @copy (c)2023 AIT Austrian Institute of Technology
 */

#pragma once
#ifndef _INC_targetsection_H_
#define _INC_targetsection_H_

#if 0
    #define XIL_INTERNAL_RAM    __attribute__((section(".local_memory")))
#else
    /* FreeRTOS runs out of Block-RAM, everything is local memory by default */
    #define XIL_INTERNAL_RAM
#endif

#define SECTION_PDOK_PROCESS_TPDO_CB    XIL_INTERNAL_RAM
#define SECTION_PDOK_COPY_TPDO          XIL_INTERNAL_RAM
#define SECTION_PDOK_PROCESS_RPDO       XIL_INTERNAL_RAM
#define SECTION_EVENTK_PROCESS          XIL_INTERNAL_RAM
#define SECTION_EVENTK_POST             XIL_INTERNAL_RAM
#define SECTION_OMETHLIB_RX_IRQ_HDL     XIL_INTERNAL_RAM
#define SECTION_OMETHLIB_TX_IRQ_HDL     XIL_INTERNAL_RAM
#define SECTION_EDRVOPENMAC_RX_HOOK     XIL_INTERNAL_RAM
#define SECTION_EDRVOPENMAC_IRQ_HDL     XIL_INTERNAL_RAM
#define SECTION_MAIN_APP_CB_SYNC        XIL_INTERNAL_RAM
#define SECTION_DLLK_FRAME_RCVD_CB      XIL_INTERNAL_RAM

#endif /* _INC_targetsection_H_ */
