/**
 * @file freertos-microblaze/systemtimer.h
 * @brief Implements the system timer of openPOWERLINK stack for FreeRTOS/Microblaze
 *
 * @copy 2023 AIT Austrian Institute of Technology
 * @see xilinx-microblaze/systemtimer.h
 * @ingroup module_target
 */
#ifndef _INC_freertos_microblaze_systemtimer_H_
#define _INC_freertos_microblaze_systemtimer_H_

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdint.h>

void         timer_init(void);
unsigned int timer_getMsCount(void);
uint64_t     timer_getCount(void);
void         timer_updateNettime(uint64_t tsSoc, uint32_t sec, uint32_t nsec);
uint64_t     timer_getTimestamp();

#ifdef __cplusplus
}
#endif

#endif /* _INC_freertos_microblaze_systemtimer_H_ */
