#-------------------------------------------------------------------------------
#
# cmake(1) configuration for openPOWERLINK CN library on Xilinx/Ultrascale AArch64
#
# (c)2018 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

#################################################################################
# D E M O   I D E N T I F I C A T I O N

# Name of the demo
set(CFG_DEMO_NAME "mn-single-gpio")

# Board of the demo
set(CFG_DEMO_BOARD_NAME "cdi2ifb")

# Bus system used in the demo
set(CFG_DEMO_BUS_SYSTEM "axi")

################################################################################
# P R O C E S S O R   F E A T U R E S   ( P C P )

# Name of the POWERLINK processor
set(CFG_PCP_NAME psu_cortexa53_0)

# Processor type that matches CMAKE_SYSTEM_PROCESSOR in toolchain file
set(CFG_PCP_PROCESSOR Ultrascale)

# Version of the Microblaze instance
set(CFG_PCP_CPU_VERSION "v3.2")

################################################################################
# E N A B L E   P R O C E S S O R   S O F T W A R E   ( P C P )

# Enable openMAC driver (omethlib)
set(CFG_PCP_OMETHLIB_ENABLE "TRUE")

################################################################################
# Set paths
set(ARCH_INSTALL_POSTFIX ${CFG_DEMO_BOARD_NAME}/${CFG_DEMO_NAME})

################################################################################
# Find boards support package
set(XIL_BSP_DIR "${OPLK_BASE_DIR}/../../BSP/CDI2IFB_bsp")

message(STATUS "Searching for the board support package in ${XIL_BSP_DIR}")
if(EXISTS ${XIL_BSP_DIR})
    set(XIL_LIB_BSP_INC "${XIL_BSP_DIR}/${CFG_PCP_NAME}/include")
else()
    message(FATAL_ERROR "Board support package for board ${CFG_DEMO_BOARD_NAME} and demo ${CFG_DEMO_NAME} not found!")
endif()

################################################################################
# Set architecture specific sources: Ultrascale+ HAL, OpenMAC driver library, and Object Dictionary
set(LIB_ARCH_SOURCES ${TARGET_ULTRASCALE_SOURCES}
                     ${TARGET_ULTRASCALE_LOCAL_SOURCES}
                     ${TARGET_ULTRASCALE_OPENMAC_SOURCES}
                     ${OPLK_BASE_DIR}/hardware/drivers/openmac/src/omethlib.c
                     ${OPLK_BASE_DIR}/hardware/drivers/openmac/src/omethlibint.c
                     ${OPLK_BASE_DIR}/apps/common/src/obdcreate/obdcreate.c
                     ${SDO_SOCKETWRAPPER_SOURCES})

################################################################################
# Set architecture specific includes: Ultrascale+ HAL, OpenMAC driver library, and Object Dictionary
include_directories(${XIL_LIB_BSP_INC}
                    ${ARCH_SOURCE_DIR}/xilinx-ultrascale
                    ${CONTRIB_SOURCE_DIR}/socketwrapper
                    ${OPLK_BASE_DIR}/hardware/drivers/openmac/include
                    ${OPLK_BASE_DIR}/../../BSP/CDI2IFB/src/include/powerlink/mn
                    ${OPLK_BASE_DIR}/apps/common/src)

################################################################################
# Set additional target specific compile flags
set(CMAKE_C_FLAGS "${CMAKE_C_FLAGS} -ffunction-sections -fdata-sections -DCONFIG_EXT_SYNC_LATENCY_US=4 -DCONFIG_EXT_SYNC_PULSE_NS=1000")

########################################################################
# Eclipse project files
gen_eclipse_file_list("${LIB_KERNEL_SOURCES}" "kernel" PART_ECLIPSE_FILE_LIST)
set(ECLIPSE_FILE_LIST "${ECLIPSE_FILE_LIST} ${PART_ECLIPSE_FILE_LIST}")

gen_eclipse_file_list("${LIB_USER_SOURCES}" "user" PART_ECLIPSE_FILE_LIST)
set(ECLIPSE_FILE_LIST "${ECLIPSE_FILE_LIST} ${PART_ECLIPSE_FILE_LIST}")

gen_eclipse_file_list("${LIB_COMMON_SOURCES}" "common" PART_ECLIPSE_FILE_LIST)
set(ECLIPSE_FILE_LIST "${ECLIPSE_FILE_LIST} ${PART_ECLIPSE_FILE_LIST}")

gen_eclipse_file_list("${LIB_ARCH_SOURCES}" "arch" PART_ECLIPSE_FILE_LIST)
set(ECLIPSE_FILE_LIST "${ECLIPSE_FILE_LIST} ${PART_ECLIPSE_FILE_LIST}")

get_property(LIBRARY_INCLUDES DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR} PROPERTY INCLUDE_DIRECTORIES)
gen_eclipse_include_list("${LIBRARY_INCLUDES}" ECLIPSE_INCLUDE_LIST)

configure_file(${XIL_TOOLS_DIR}/eclipse/libproject.in  ${PROJECT_BINARY_DIR}/.project @ONLY)
configure_file(${XIL_TOOLS_DIR}/eclipse/libcproject.in ${PROJECT_BINARY_DIR}/.cproject @ONLY)
