/**
********************************************************************************
\file   objdicts/CiA302-4_MN/objdict.h

\brief  Object dictionary according to CiA302-4

This file contains the object dictionary definition for the CANopen CiA302-4
device profile.
*******************************************************************************/

/*------------------------------------------------------------------------------
Copyright (c) 2016, Bernecker+Rainer Industrie-Elektronik Ges.m.b.H. (B&R)
Copyright (c) 2013, SYSTEC electronic GmbH
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
------------------------------------------------------------------------------*/

#define OBD_DEFINE_MACRO
    #include <obdcreate/obdmacro.h>
#undef OBD_DEFINE_MACRO

OBD_BEGIN()
    /*************************************************************************
     * Communication Profile Area (0x1000 - 0x1FFF)
     *************************************************************************/
    OBD_BEGIN_PART_GENERIC()

        // Object 1000h: NMT_DeviceType_U32
        OBD_BEGIN_INDEX_RAM(0x1000, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1000, 0x00, kObdTypeUInt32, kObdAccR, tObdUnsigned32, NMT_DeviceType_U32, 0x00000000)
        OBD_END_INDEX(0x1000)

        // Object 1001h: ERR_ErrorRegister_U8
        OBD_BEGIN_INDEX_RAM(0x1001, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1001, 0x00, kObdTypeUInt8, kObdAccR, tObdUnsigned8, ERR_ErrorRegister_U8, 0x00)
        OBD_END_INDEX(0x1001)

/*
        // Object 1003h: ERR_History_ADOM
        OBD_RAM_INDEX_RAM_VARARRAY_NOINIT(0x1003, 10, FALSE, tObdDomain, kObdAccR, tObdDomain, ERR_History_ADOM)
*/

        // Object 1006h: NMT_CycleLen_U32 in [us]
        OBD_BEGIN_INDEX_RAM(0x1006, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1006, 0x00, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, NMT_CycleLen_U32, 1000)   // in [us]
        OBD_END_INDEX(0x1006)

        // Object 1008h: NMT_ManufactDevName_VS
        OBD_BEGIN_INDEX_RAM(0x1008, 0x01, FALSE)
           OBD_SUBINDEX_RAM_VSTRING(0x1008, 0x00, kObdAccR, device_name, OBD_MAX_STRING_SIZE, "CDI2 device")
        OBD_END_INDEX(0x1008)

        // Object 1009h: NMT_ManufactHwVers_VS
        OBD_BEGIN_INDEX_RAM(0x1009, 0x01, FALSE)
           OBD_SUBINDEX_RAM_VSTRING(0x1009, 0x00, kObdAccR, hardware_version, OBD_MAX_STRING_SIZE, "1.00")
        OBD_END_INDEX(0x1009)

        // Object 100Ah: NMT_ManufactSwVers_VS
        OBD_BEGIN_INDEX_RAM(0x100A, 0x01, FALSE)
           OBD_SUBINDEX_RAM_VSTRING(0x100A, 0x00, kObdAccR, software_version, OBD_MAX_STRING_SIZE, PLK_PRODUCT_NAME" "PLK_PRODUCT_VERSION)
        OBD_END_INDEX(0x100A)

#if defined(CONFIG_OBD_USE_STORE_RESTORE)
        // Object 1010h: NMT_StoreParam_REC
        OBD_BEGIN_INDEX_RAM(0x1010, 0x05, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1010, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x04)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1010, 0x01, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, AllParam_U32)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1010, 0x02, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, CommunicationParam_U32)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1010, 0x03, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, ApplicationParam_U32)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1010, 0x04, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, ManufacturerParam_U32)
        OBD_END_INDEX(0x1010)

        // Object 1011h: NMT_RestoreDefParam_REC
        OBD_BEGIN_INDEX_RAM(0x1011, 0x05, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1011, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x04)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1011, 0x01, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, AllParam_U32)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1011, 0x02, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, CommunicationParam_U32)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1011, 0x03, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, ApplicationParam_U32)
            OBD_SUBINDEX_RAM_VAR_NOINIT(0x1011, 0x04, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, ManufacturerParam_U32)
        OBD_END_INDEX(0x1011)
#endif

        // Object 1018h: NMT_IdentityObject_REC
        OBD_BEGIN_INDEX_RAM(0x1018, 0x05, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1018, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x04)
            OBD_SUBINDEX_RAM_VAR(0x1018, 0x01, kObdTypeUInt32, kObdAccR, tObdUnsigned32, VendorId_U32, 0x00000000)
            OBD_SUBINDEX_RAM_VAR(0x1018, 0x02, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ProductCode_U32, 0x00000000)
            OBD_SUBINDEX_RAM_VAR(0x1018, 0x03, kObdTypeUInt32, kObdAccR, tObdUnsigned32, RevisionNo_U32, PLK_DEFINED_OBJ1018_VERSION)
            OBD_SUBINDEX_RAM_VAR(0x1018, 0x04, kObdTypeUInt32, kObdAccR, tObdUnsigned32, SerialNo_U32, 0x00000000)
        OBD_END_INDEX(0x1018)

        // Object 1020h: CFM_VerifyConfiguration_REC
        OBD_BEGIN_INDEX_RAM(0x1020, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1020, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR(0x1020, 0x01, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, ConfDate_U32, 0x00000000)
            OBD_SUBINDEX_RAM_VAR(0x1020, 0x02, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, ConfTime_U32, 0x00000000)
//            OBD_SUBINDEX_RAM_VAR(0x1020, 0x03, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, ConfId_U32, 0x00000000)
//            OBD_SUBINDEX_RAM_VAR(0x1020, 0x04, kObdTypeBool, kObdAccR, tObdBoolean, VerifyConfInvalid_BOOL, 0x01)
        OBD_END_INDEX(0x1020)

        // Object 1030h: NMT_InterfaceGroup_Xh_REC
        OBD_BEGIN_INDEX_RAM(0x1030, 0x0A, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1030, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x09)
            OBD_SUBINDEX_RAM_VAR_RG(0x1030, 0x01, kObdTypeUInt16, kObdAccR, tObdUnsigned16, InterfaceIndex_U16, 0x01, 0x00, 0x0A)
            OBD_SUBINDEX_RAM_VSTRING(0x1030, 0x02, kObdAccR, InterfaceDescription_VSTR, 0x20, "Interface 1")
            OBD_SUBINDEX_RAM_VAR(0x1030, 0x03, kObdTypeUInt8, kObdAccR, tObdUnsigned8, InterfaceType_U8, 0x06)
            OBD_SUBINDEX_RAM_VAR(0x1030, 0x04, kObdTypeUInt16, kObdAccR, tObdUnsigned16, InterfaceMtu_U16, 1518)
            OBD_SUBINDEX_RAM_OSTRING(0x1030, 0x05, kObdAccR, InterfacePhysAddress_OSTR, 0x06)
            OBD_SUBINDEX_RAM_VSTRING(0x1030, 0x06, kObdAccR, InterfaceName_VSTR, 0x20, "Interface 1")
            OBD_SUBINDEX_RAM_VAR_RG(0x1030, 0x07, kObdTypeUInt8, kObdAccR, tObdUnsigned8, InterfaceOperStatus_U8, 0x01, 0x00, 0x01)
            OBD_SUBINDEX_RAM_VAR_RG(0x1030, 0x08, kObdTypeUInt8, kObdAccGRW, tObdUnsigned8, InterfaceAdminState_U8, 0x01, 0x00, 0x01)
            OBD_SUBINDEX_RAM_VAR(0x1030, 0x09, kObdTypeBool, kObdAccRW, tObdBoolean, Valid_BOOL, 0x01)
        OBD_END_INDEX(0x1030)

#if (defined(CONFIG_DLL_PRES_CHAINING_CN) && (NMT_MAX_NODE_ID > 0))
        // Object 1050h: NMT_RelativeLatencyDiff_AU32
        OBD_RAM_INDEX_RAM_ARRAY(0x1050, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt32, kObdAccR, tObdUnsigned32, NMT_RelativeLatencyDiff_AU32, 0)
#endif

        // Object 1300h: SDO_SequLayerTimeout_U32 in [ms]
        OBD_BEGIN_INDEX_RAM(0x1300, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR_RG(0x1300, 0x00, kObdTypeUInt32, kObdAccSGRW, tObdUnsigned32, SDO_SequLayerTimeout_U32, 15000, 100, 0xFFFFFFFF)
        OBD_END_INDEX(0x1300)


        // Object 1400h: PDO_RxCommParam_00h_REC
        OBD_BEGIN_INDEX_RAM(0x1400, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1400, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1400, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1400, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1400)

        // Object 1401h: PDO_RxCommParam_01h_REC
        OBD_BEGIN_INDEX_RAM(0x1401, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1401, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1401, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1401, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1401)

        // Object 1402h: PDO_RxCommParam_02h_REC
        OBD_BEGIN_INDEX_RAM(0x1402, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1402, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1402, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1402, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1402)

        // Object 1403h: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x1403, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1403, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1403, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1403, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1403)

        // Object 1404h: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x1404, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1404, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1404, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1404, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1404)

        // Object 1405h: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x1405, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1405, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1405, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1405, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1405)

        // Object 1406h: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x1406, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1406, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1406, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1406, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1406)

        // Object 1407h: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x1407, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1407, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1407, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1407, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1407)

        // Object 1408h: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x1408, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1408, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1408, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1408, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1408)

        // Object 1409h: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x1409, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1409, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1409, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1409, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1409)

        // Object 140Ah: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x140A, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x140A, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x140A, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x140A, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x140A)

        // Object 140Bh: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x140B, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x140B, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x140B, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x140B, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x140B)

        // Object 140Ch: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x140C, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x140C, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x140C, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x140C, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x140C)

        // Object 140Dh: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x140D, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x140D, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x140D, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x140D, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x140D)

        // Object 140Eh: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x140E, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x140E, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x140E, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x140E, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x140E)

        // Object 140Fh: PDO_RxCommParam_03h_REC
        OBD_BEGIN_INDEX_RAM(0x140F, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x140F, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x140F, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x140F, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x140F)

        // Object 1600h: PDO_RxMappParam_00h_AU64
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1600, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1601, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1602, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1603, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1604, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1605, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1606, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1607, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1608, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1609, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x160A, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x160B, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x160C, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x160D, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x160E, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x160F, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)

        // Object 1800h: PDO_TxCommParam_00h_REC
        OBD_BEGIN_INDEX_RAM(0x1800, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1800, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1800, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1800, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1800)

        OBD_BEGIN_INDEX_RAM(0x1801, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1801, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1801, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1801, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1801)

        OBD_BEGIN_INDEX_RAM(0x1802, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1802, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1802, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1802, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1802)

        OBD_BEGIN_INDEX_RAM(0x1803, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1803, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1803, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1803, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1803)

        OBD_BEGIN_INDEX_RAM(0x1804, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1804, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1804, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1804, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1804)

        OBD_BEGIN_INDEX_RAM(0x1805, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1805, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1805, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1805, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1805)

        OBD_BEGIN_INDEX_RAM(0x1806, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1806, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1806, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1806, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1806)

        OBD_BEGIN_INDEX_RAM(0x1807, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1807, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1807, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1807, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1807)

        OBD_BEGIN_INDEX_RAM(0x1808, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1808, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1808, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1808, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1808)

        OBD_BEGIN_INDEX_RAM(0x1809, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1809, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1809, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1809, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1809)

        OBD_BEGIN_INDEX_RAM(0x180A, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x180A, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x180A, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x180A, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x180A)

        OBD_BEGIN_INDEX_RAM(0x180B, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x180B, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x180B, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x180B, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x180B)

        OBD_BEGIN_INDEX_RAM(0x180C, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x180C, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x180C, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x180C, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x180C)

        OBD_BEGIN_INDEX_RAM(0x180D, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x180D, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x180D, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x180D, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x180D)

        OBD_BEGIN_INDEX_RAM(0x180E, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x180E, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x180E, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x180E, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x180E)

        OBD_BEGIN_INDEX_RAM(0x180F, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x180F, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x180F, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x180F, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x180F)

        OBD_BEGIN_INDEX_RAM(0x1810, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1810, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR_RG(0x1810, 0x01, kObdTypeUInt8, kObdAccSGRW, tObdUnsigned8, NodeID_U8, 0, 0, 255)
            OBD_SUBINDEX_RAM_VAR(0x1810, 0x02, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MappingVersion_U8, 0x00)
        OBD_END_INDEX(0x1810)

        // Object 1A00h: PDO_TxMappParam_00h_AU64
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A00, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A01, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A02, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A03, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A04, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A05, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A06, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A07, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A08, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A09, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A0A, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A0B, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A0C, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A0D, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A0E, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A0F, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)
        OBD_RAM_INDEX_RAM_PDO_MAPPING(0x1A10, 0x1, FALSE, kObdAccSRW, ObjectMapping, 0)

        // Object 1C00h: DLL_MNCRCError_REC
        OBD_BEGIN_INDEX_RAM(0x1C00, 0x04, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1C00, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x03)
            OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x1C00, 0x01, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, CumulativeCnt_U32)
            OBD_SUBINDEX_RAM_USERDEF(0x1C00, 0x02, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ThresholdCnt_U32, 0)
            OBD_SUBINDEX_RAM_USERDEF(0x1C00, 0x03, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, Threshold_U32, 1)
        OBD_END_INDEX(0x1C00)

        // Object 1C02h: DLL_MNCycTimeExceed_REC
        OBD_BEGIN_INDEX_RAM(0x1C02, 0x04, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1C02, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x03)
            OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x1C02, 0x01, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, CumulativeCnt_U32)
            OBD_SUBINDEX_RAM_USERDEF(0x1C02, 0x02, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ThresholdCnt_U32, 0)
            OBD_SUBINDEX_RAM_USERDEF(0x1C02, 0x03, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, Threshold_U32, 1)
        OBD_END_INDEX(0x1C02)

        // Object 1C07h: DLL_MNCNLossPResCumCnt_AU32
        OBD_RAM_INDEX_RAM_VARARRAY_NOINIT(0x1C07, 254, FALSE, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, DLL_MNCNLossPResCumCnt_AU32)

        // Object 1C08h: DLL_MNCNLossPResThrCnt_AU32
        OBD_RAM_INDEX_RAM_VARARRAY(0x1C08, 254, FALSE, kObdTypeUInt32, kObdAccR, tObdUnsigned32, DLL_MNCNLossPResThrCnt_AU32, 0)

        // Object 1C09h: DLL_MNCNLossPResThreshold_AU32
        OBD_RAM_INDEX_RAM_VARARRAY(0x1C09, 254, FALSE, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, DLL_MNCNLossPResThreshold_AU32, 23)

        // Object 1C0Bh: DLL_CNLossSoC_REC
        OBD_BEGIN_INDEX_RAM(0x1C0B, 0x04, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1C0B, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 3)
            OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x1C0B, 0x01, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, CumulativeCnt_U32)
            OBD_SUBINDEX_RAM_USERDEF(0x1C0B, 0x02, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ThresholdCnt_U32, 0)
            OBD_SUBINDEX_RAM_USERDEF(0x1C0B, 0x03, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, Threshold_U32, 15)
        OBD_END_INDEX(0x1C0B)

        // Object 1C0Dh: DLL_CNLossPReq_REC
        OBD_BEGIN_INDEX_RAM(0x1C0D, 0x04, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1C0D, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 3)
            OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x1C0D, 0x01, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, CumulativeCnt_U32)
            OBD_SUBINDEX_RAM_USERDEF(0x1C0D, 0x02, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ThresholdCnt_U32, 0)
            OBD_SUBINDEX_RAM_USERDEF(0x1C0D, 0x03, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, Threshold_U32, 15)
        OBD_END_INDEX(0x1C0D)

        // Object 1C0Fh: DLL_CNCRCError_REC
        OBD_BEGIN_INDEX_RAM(0x1C0F, 0x04, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1C0F, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 3)
            OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x1C0F, 0x01, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, CumulativeCnt_U32)
            OBD_SUBINDEX_RAM_USERDEF(0x1C0F, 0x02, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ThresholdCnt_U32, 0)
            OBD_SUBINDEX_RAM_USERDEF(0x1C0F, 0x03, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, Threshold_U32, 1)
        OBD_END_INDEX(0x1C0F)

        // Object 1C12h: DLL_MNCycleSuspendNumber_U32
        OBD_BEGIN_INDEX_RAM(0x1C12, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1C12, 0x00, kObdTypeUInt32, kObdAccRW, tObdUnsigned32, MNCycleSuspendNumber, 1)
        OBD_END_INDEX(0x1C12)

        // Object 1C14h: DLL_LossOfSocTolerance_U32 in [ns]
        OBD_BEGIN_INDEX_RAM(0x1C14, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1C14, 0x00, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, LossOfSocTolerance, 100000)
        OBD_END_INDEX(0x1C14)

        // Object 1C16h: DLL_MNLossStatusResThrCnt_AU32
        OBD_RAM_INDEX_RAM_ARRAY(0x1C16, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt32, kObdAccR, tObdUnsigned32, DLL_MNLossStatusResThrCnt_AU32, 0)

        // Object 1C17h: DLL_MNLossStatusResThreshold_AU32
        OBD_RAM_INDEX_RAM_ARRAY(0x1C17, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, DLL_MNLossStatusResThreshold_AU32, 15)

#if defined(CONFIG_INCLUDE_IP)
        // Object 1E40h: NWL_IpAddrTable_0h_REC
        OBD_BEGIN_INDEX_RAM(0x1E40, 0x06, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1E40, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x05)
            OBD_SUBINDEX_RAM_VAR(0x1E40, 0x01, kObdTypeUInt16, kObdAccR, tObdUnsigned16, IfIndex_U16, 0x01)
            OBD_SUBINDEX_RAM_VAR(0x1E40, 0x02, kObdTypeUInt32, kObdAccR, tObdUnsigned32, Addr_IPAD, 0xC0A86401)
            OBD_SUBINDEX_RAM_VAR(0x1E40, 0x03, kObdTypeUInt32, kObdAccR, tObdUnsigned32, NetMask_IPAD, 0xFFFFFF00)
            OBD_SUBINDEX_RAM_VAR(0x1E40, 0x04, kObdTypeUInt16, kObdAccR, tObdUnsigned16, ReasmMaxSize_U16, 50000)
            OBD_SUBINDEX_RAM_VAR(0x1E40, 0x05, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, DefaultGateway_IPAD, 0xC0A864FE)
        OBD_END_INDEX(0x1E40)

        // Object 1E4Ah: NWL_IpGroup_REC
        OBD_BEGIN_INDEX_RAM(0x1E4A, 0x06, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1E4A, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x03)
            OBD_SUBINDEX_RAM_VAR(0x1E4A, 0x01, kObdTypeBool, kObdAccSRW, tObdBoolean, Forwarding_BOOL, 0x00)
            OBD_SUBINDEX_RAM_VAR(0x1E4A, 0x02, kObdTypeUInt16, kObdAccSRW, tObdUnsigned16, DefaultTTL_U16, 64)
            OBD_SUBINDEX_RAM_VAR(0x1E4A, 0x03, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ForwardDatagrams_U32, 0x00000000)
        OBD_END_INDEX(0x1E4A)
#endif

#if defined(CONFIG_INCLUDE_CFM)
        OBD_RAM_INDEX_RAM_VARARRAY_NOINIT(0x1F22, NMT_MAX_NODE_ID, FALSE, kObdTypeDomain, kObdAccSRW, Domain, CFM_ConciseDcfList_ADOM)
        OBD_RAM_INDEX_RAM_ARRAY(0x1F26, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, CFM_ExpConfDateList_AU32, 0x00000000)
        OBD_RAM_INDEX_RAM_ARRAY(0x1F27, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, CFM_ExpConfTimeList_AU32, 0x00000000)
#endif

        // Object 1F80h: NMT_StartUp_U32
        OBD_BEGIN_INDEX_RAM(0x1F80, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F80, 0x00, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, NMT_StartUp_U32, 0x00000800)
        OBD_END_INDEX(0x1F80)

        // Object 1F81h: NMT_NodeAssignment_AU32
        OBD_RAM_INDEX_RAM_ARRAY_ALT(0x1F81, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, NMT_NodeAssignment_AU32, 0x00000000)

        // Object 1F82h: NMT_FeatureFlags_U32
        OBD_BEGIN_INDEX_RAM(0x1F82, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F82, 0x00, kObdTypeUInt32, kObdAccR, tObdUnsigned32, NMT_FeatureFlags_U32, PLK_DEF_FEATURE_FLAGS)
        OBD_END_INDEX(0x1F82)

        // Object 1F83h: NMT_EPLVersion_U8
        OBD_BEGIN_INDEX_RAM(0x1F83, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F83, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NMT_EPLVersion_U8, 0x20)
        OBD_END_INDEX(0x1F83)

        // Object 1F84h: NMT_MNDeviceTypeIdList_AU32
        OBD_RAM_INDEX_RAM_ARRAY_ALT(0x1F84, 254, FALSE, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, NMT_MNDeviceTypeIdList_AU32, 0x00000000)

        // Object 1F89h: NMT_BootTime_REC
#if defined(CONFIG_INCLUDE_NMT_RMN)
        OBD_BEGIN_INDEX_RAM(0x1F89, 0x09, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x1F89, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x0C)
#else
        OBD_BEGIN_INDEX_RAM(0x1F89, 0x06, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x1F89, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x05)
#endif
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x01, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNWaitNotAct_U32, 1000000)       // in [us]
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x02, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNTimeoutPreOp1_U32, 500000)     // in [us]
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x03, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNWaitPreOp1_U32, 500000)        // in [us]
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x04, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNTimeoutPreOp2_U32, 500000)     // in [us]
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x05, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNTimeoutReadyToOp_U32, 500000)  // in [us]
#if defined(CONFIG_INCLUDE_NMT_RMN)
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x0A, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNSwitchOverPriority_U32, 10)
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x0B, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNSwitchOverDelay_U32, 10)
            OBD_SUBINDEX_RAM_VAR(0x1F89, 0x0C, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, MNSwitchOverCycleDivider_U32, 10)
#endif
        OBD_END_INDEX(0x1F89)

        // Object 1F8Ah: NMT_MNCycleTiming_REC
        OBD_BEGIN_INDEX_RAM(0x1F8A, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F8A, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR(0x1F8A, 0x01, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, WaitSoCPReq_U32, 1000)           // in [ns]
            OBD_SUBINDEX_RAM_VAR_RG(0x1F8A, 0x02, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, AsyncSlotTimeout_U32, 100000, 250, 0xFFFFFFFF) // in [ns]
        OBD_END_INDEX(0x1F8A)

        // Object 1F8Bh: NMT_MNPReqPayloadLimitList_AU16
        OBD_RAM_INDEX_RAM_ARRAY_ALT(0x1F8B, 254, FALSE, kObdTypeUInt16, kObdAccSRW, tObdUnsigned16, NMT_MNPReqPayloadLimitList_AU16, 0)

        // Object 1F8Ch: NMT_CurrNMTState_U8
        OBD_BEGIN_INDEX_RAM(0x1F8C, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F8C, 0x00, kObdTypeUInt8, (kObdAccR | kObdAccPdo), tObdUnsigned8, NMT_CurrNMTState_U8, 0x1C)
        OBD_END_INDEX(0x1F8C)

        // Object 1F8Dh: NMT_PResPayloadLimitList_AU16
        OBD_RAM_INDEX_RAM_ARRAY_ALT(0x1F8D, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt16, kObdAccSRW, tObdUnsigned16, NMT_PResPayloadLimitList_AU16, 0)

        // Object 1F8Eh: NMT_MNNodeCurrState_AU8
        OBD_RAM_INDEX_RAM_ARRAY(0x1F8E, 254, FALSE, kObdTypeUInt8, kObdAccR, tObdUnsigned8, NMT_MNNodeCurrState_AU8, 0x1C)

        // Object 1F8Fh: NMT_MNNodeExpState_AU8
        OBD_RAM_INDEX_RAM_ARRAY(0x1F8F, 254, FALSE, kObdTypeUInt8, kObdAccR, tObdUnsigned8, NMT_MNNodeExpState_AU8, 0x1C)

        // Object 1F92h: NMT_MNCNPResTimeout_AU32 in [ns]
        OBD_RAM_INDEX_RAM_ARRAY_ALT(0x1F92, 254, FALSE, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, NMT_MNCNPResTimeout_AU32, 25000) // in [ns]

        // Object 1F93h: NMT_EPLNodeID_REC
        OBD_BEGIN_INDEX_RAM(0x1F93, 0x03, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F93, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x02)
            OBD_SUBINDEX_RAM_VAR(0x1F93, 0x01, kObdTypeUInt8, kObdAccR, tObdUnsigned8, NodeID_U8, 0)
            OBD_SUBINDEX_RAM_VAR(0x1F93, 0x02, kObdTypeBool, kObdAccR, tObdBoolean, NodeIDByHW_BOOL, 0x00)
        OBD_END_INDEX(0x1F93)

        // Object 1F98h: NMT_CycleTiming_REC
#if !defined(CONFIG_DLL_PRES_CHAINING_CN)
        OBD_BEGIN_INDEX_RAM(0x1F98, 0x0A, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x09)
#else
        OBD_BEGIN_INDEX_RAM(0x1F98, 0x0F, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x0E)
#endif
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x01, kObdTypeUInt16, kObdAccR, tObdUnsigned16, IsochrTxMaxPayload_U16, 0)
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x02, kObdTypeUInt16, kObdAccR, tObdUnsigned16, IsochrRxMaxPayload_U16, 0)
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x03, kObdTypeUInt32, kObdAccR, tObdUnsigned32, PResMaxLatency_U32, 0x00000000)     // in [ns]
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x04, kObdTypeUInt16, kObdAccSRW, tObdUnsigned16, PReqActPayloadLimit_U16, 0)
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x05, kObdTypeUInt16, kObdAccSRW, tObdUnsigned16, PResActPayloadLimit_U16, 0)
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x06, kObdTypeUInt32, kObdAccR, tObdUnsigned32, ASndMaxLatency_U32, 0x00000000)     // in [ns]
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x07, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, MultiplCycleCnt_U8, 0x00)
            OBD_SUBINDEX_RAM_VAR_RG(0x1F98, 0x08, kObdTypeUInt16, kObdAccSGRW, tObdUnsigned16, AsyncMTU_U16, C_DLL_MIN_ASYNC_MTU, C_DLL_MIN_ASYNC_MTU, C_DLL_MAX_ASYNC_MTU)
            OBD_SUBINDEX_RAM_VAR_RG(0x1F98, 0x09, kObdTypeUInt16, kObdAccSRW, tObdUnsigned16, Prescaler_U16, 2, 0, 1000)
#if defined(CONFIG_DLL_PRES_CHAINING_CN)
            OBD_SUBINDEX_RAM_VAR_RG(0x1F98, 0x0A, kObdTypeUInt8, kObdAccGR, tObdUnsigned8, PResMode_U8, 0x00, 0x00, 0x01)
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x0B, kObdTypeUInt32, kObdAccR, tObdUnsigned32, PResTimeFirst_U32, 0)      // in [ns]
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x0C, kObdTypeUInt32, kObdAccR, tObdUnsigned32, PResTimeSecond_U32, 0)     // in [ns]
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x0D, kObdTypeUInt32, kObdAccR, tObdUnsigned32, SyncMNDelayFirst_U32, 0)   // in [ns]
            OBD_SUBINDEX_RAM_VAR(0x1F98, 0x0E, kObdTypeUInt32, kObdAccR, tObdUnsigned32, SyncMNDelaySecond_U32, 0)  // in [ns]
#endif
        OBD_END_INDEX(0x1F98)

        // Object 1F99h: NMT_CNBasicEthernetTimeout_U32 in [us]
        OBD_BEGIN_INDEX_RAM(0x1F99, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F99, 0x00, kObdTypeUInt32, kObdAccSRW, tObdUnsigned32, NMT_CNBasicEthernetTimeout_U32, 5000000)  // in [us]
        OBD_END_INDEX(0x1F99)

#if defined(CONFIG_INCLUDE_IP)
        // Object 1F9Ah: NMT_HostName_VSTR
        OBD_BEGIN_INDEX_RAM(0x1F9A, 0x01, FALSE)
           OBD_SUBINDEX_RAM_VSTRING(0x1F9A, 0x00, kObdAccSRW, NMT_HostName_VSTR, 34, "")
        OBD_END_INDEX(0x1F9A)
#endif

        // Object 1F9Bh: NMT_MultiplCycleAssign_AU8
        OBD_RAM_INDEX_RAM_ARRAY_ALT(0x1F9B, NMT_MAX_NODE_ID, FALSE, kObdTypeUInt8, kObdAccSRW, tObdUnsigned8, NMT_MultiplCycleAssign_AU8, 0)

        // Object 1F9Eh: NMT_ResetCmd_U8
        OBD_BEGIN_INDEX_RAM(0x1F9E, 0x01, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F9E, 0x00, kObdTypeUInt8, kObdAccRW, tObdUnsigned8, NMT_ResetCmd_U8, 0xFF)
        OBD_END_INDEX(0x1F9E)

        // Object 1F9Fh: NMT_RequestCmd_REC
        OBD_BEGIN_INDEX_RAM(0x1F9F, 0x05, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F9F, 0x00, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 0x04)
            OBD_SUBINDEX_RAM_VAR(0x1F9F, 0x01, kObdTypeBool, kObdAccRW, tObdBoolean, Release_BOOL, FALSE)
            OBD_SUBINDEX_RAM_VAR(0x1F9F, 0x02, kObdTypeUInt8, kObdAccRW, tObdUnsigned8, CmdID_U8, 0xFF)
            OBD_SUBINDEX_RAM_VAR(0x1F9F, 0x03, kObdTypeUInt8, kObdAccRW, tObdUnsigned8, CmdTarget_U8, 0x00)
            OBD_SUBINDEX_RAM_DOMAIN(0x1F9F, 0x04, kObdAccVRW, CmdData_DOM)
        OBD_END_INDEX(0x1F9F)
    OBD_END_PART()

    /*************************************************************************
     * Manufacturer Specific Profile Area (0x2000 - 0x5FFF)
     *************************************************************************/
    OBD_BEGIN_PART_MANUFACTURER()


    OBD_BEGIN_INDEX_RAM(0x2000, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2000,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2000, 1, kObdTypeDomain, kObdAccVPR, tObdDomain, Data)
    OBD_END_INDEX(0x2000)

    // Static PReq Data for future use
    OBD_BEGIN_INDEX_RAM(0x2001, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2001,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2001, 1, kObdTypeDomain, kObdAccVPR, tObdDomain, Data)
    OBD_END_INDEX(0x2001)

    OBD_BEGIN_INDEX_RAM(0x2010, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2010,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2010, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2010)

    OBD_BEGIN_INDEX_RAM(0x2011, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2011,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2011, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2011)

    OBD_BEGIN_INDEX_RAM(0x2012, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2012,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2012, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2012)

    OBD_BEGIN_INDEX_RAM(0x2013, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2013,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2013, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2013)

    OBD_BEGIN_INDEX_RAM(0x2014, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2014,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2014, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2014)

    OBD_BEGIN_INDEX_RAM(0x2015, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2015,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2015, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2015)

    OBD_BEGIN_INDEX_RAM(0x2016, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2016,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2016, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2016)

    OBD_BEGIN_INDEX_RAM(0x2017, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2017,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2017, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2017)

    OBD_BEGIN_INDEX_RAM(0x2018, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2018,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2018, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2018)

    OBD_BEGIN_INDEX_RAM(0x2019, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x2019,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x2019, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x2019)

    OBD_BEGIN_INDEX_RAM(0x201A, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x201A,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x201A, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x201A)

    OBD_BEGIN_INDEX_RAM(0x201B, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x201B,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x201B, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x201B)

    OBD_BEGIN_INDEX_RAM(0x201C, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x201C,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x201C, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x201C)

    OBD_BEGIN_INDEX_RAM(0x201D, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x201D,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x201D, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x201D)

    OBD_BEGIN_INDEX_RAM(0x201E, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x201E,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x201E, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x201E)

    OBD_BEGIN_INDEX_RAM(0x201F, 2, FALSE)
        OBD_SUBINDEX_RAM_VAR(0x201F,     0, kObdTypeUInt8, kObdAccConst, tObdUnsigned8, NumberOfEntries, 1)
        OBD_SUBINDEX_RAM_USERDEF_NOINIT(0x201F, 1, kObdTypeDomain, kObdAccVPW, tObdDomain, Data)
    OBD_END_INDEX(0x201F)


    OBD_END_PART()

    OBD_BEGIN_PART_DEVICE()

    OBD_END_PART()

OBD_END()

#define OBD_UNDEFINE_MACRO
    #include <obdcreate/obdmacro.h>
#undef OBD_UNDEFINE_MACRO
