#-------------------------------------------------------------------------------
#
# cmake(1) configuration for openPOWERLINK CN library on FreeRTOS/Microblaze
#
# (c)2023 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

# set and check BSP include directory
set(XIL_BSP_DIR "${OPLK_BASE_DIR}/../../Mars_ZX2_ST3")
message(STATUS "Searching for the board support package in ${XIL_BSP_DIR}")

if(EXISTS ${XIL_BSP_DIR})
  set(XIL_LIB_BSP_INC "${XIL_BSP_DIR}/export/Mars_ZX2_ST3/sw/Mars_ZX2_ST3/freertos10_xilinx_SoftCore/bspinclude/include")
else()
  message(FATAL_ERROR "Board support package not found!")
endif()

# Set architecture specific sources
set(LIB_ARCH_SOURCES 
  ${TARGET_FREERTOS_MICROBLAZE_SOURCES}
  ${TARGET_FREERTOS_MICROBLAZE_LOCAL_SOURCES}
  ${TARGET_FREERTOS_MICROBLAZE_OPENMAC_SOURCES}
  ${ARCH_SOURCE_DIR}/freertos-microblaze/obdcreate/obdcreate.c
  ${SDO_SOCKETWRAPPER_SOURCES}
)

# Set architecture specific includes
include_directories(
  ${XIL_LIB_BSP_INC}
  ${ARCH_SOURCE_DIR}/freertos-microblaze
  ${CONTRIB_SOURCE_DIR}/socketwrapper
)

# add target specific compile flags
add_compile_definitions("CONFIG_EXT_SYNC_LATENCY_US=4")
add_compile_definitions("CONFIG_EXT_SYNC_PULSE_NS=1000")
