/**
********************************************************************************
\file   kernel/timesynck.h

\brief  Include file for kernel timesync module

*******************************************************************************/

/*------------------------------------------------------------------------------
Copyright (c) 2016, B&R Industrial Automation GmbH
Copyright (c) 2017, Kalycito Infotech Private Limited
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:
    * Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.
    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.
    * Neither the name of the copyright holders nor the
      names of its contributors may be used to endorse or promote products
      derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
------------------------------------------------------------------------------*/
#ifndef _INC_kernel_timesynck_H_
#define _INC_kernel_timesynck_H_

//------------------------------------------------------------------------------
// includes
//------------------------------------------------------------------------------
#include <common/oplkinc.h>
#include <kernel/eventk.h>
#include <common/timesync.h>

//------------------------------------------------------------------------------
// const defines
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// typedef
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
// function prototypes
//------------------------------------------------------------------------------
#ifdef __cplusplus
extern "C"
{
#endif

tOplkError timesynck_init(void);
void       timesynck_exit(void);
tOplkError timesynck_setCycleTime(UINT32 cycleLen_p, UINT32 minSyncTime_p);
tOplkError timesynck_sendSyncEvent(void);
tOplkError timesynck_process(const tEvent* pEvent_p);
tOplkError timesynck_sendExtSyncEvent(void);

#if defined(CONFIG_INCLUDE_SOC_TIME_FORWARD)
tOplkError timesynck_setSocTime(const tTimesyncSocTime* pSocTime_p);
#if defined(CONFIG_INCLUDE_NMT_MN)
tOplkError timesynck_getNetTime(tNetTime* pNetTime_p, BOOL* pNewData_p);
#endif /* defined(CONFIG_INCLUDE_NMT_MN) */
#endif /* defined(CONFIG_INCLUDE_SOC_TIME_FORWARD) */

#ifdef __cplusplus
}
#endif

#endif  /* _INC_kernel_timesynck_H_ */
