#-------------------------------------------------------------------------------
#
# cmake(1) options for openPOWERLINK stack on Xilinx/Ultrascale+ AArch64
#
# The Ultrascale variants of the openPOWERLINK libraries are linked to
# an out-of-stack BSP:
#
# |
# +-BSP
# |
# +-3rdParty/openPOWERLINK_V2/stack/cmake/options-ultrascale.cmake
#            ^
#            L ${OPLK_BASE_DIR}
#
#
# (c)2018 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

message(STATUS "Adding CMake configuration options for Xilinx Zynq Ultrascale+ AArch64")

################################################################################
# Handle includes
set(CMAKE_MODULE_PATH "${OPLK_BASE_DIR}/cmake" ${CMAKE_MODULE_PATH})
include(geneclipsefilelist)
include(geneclipseincludelist)

################################################################################
# Set Paths
SET(XIL_TOOLS_DIR  "${TOOLS_DIR}/xilinx-ultrascale")

################################################################################
# Options for MN and CN libraries
option(CONFIG_MN "Compile managing (MN, default) or controlled (CN) node variant of the openPOWERLINK library" ON)

if (CONFIG_MN)
  option(CFG_COMPILE_LIB_MN "Compile openPOWERLINK MN library" ON)
  option(CFG_COMPILE_LIB_CN "Compile openPOWERLINK CN library" OFF)
else()
  option(CFG_COMPILE_LIB_MN "Compile openPOWERLINK MN library" OFF)
  option(CFG_COMPILE_LIB_CN "Compile openPOWERLINK CN library" ON)
endif()

################################################################################
# Add library subdirectories and hardware library path

# MN libraries
if(CFG_COMPILE_LIB_MN)
  add_subdirectory(proj/generic/liboplkmn)
else()
  unset(CFG_COMPILE_LIB_MN_HW_PATH CACHE)
endif()

# CN libraries
if(CFG_COMPILE_LIB_CN)
  add_subdirectory(proj/generic/liboplkcn)
else()
  unset(CFG_COMPILE_LIB_CN_HW_PATH CACHE)
endif()
