#-------------------------------------------------------------------------------
#
# options-freertos-microblaze.cmake
#
# cmake(1) options for building the openPOWERLINK stack libraries for
# FreeRTOS/Microblaze
#
# The Microblaze variants of the openPOWERLINK libraries are linked to
# an out-of-stack BSP:
#
# |
# +-BSP
# |
# +-OpenPowerLink/src/stack/cmake/options-freertos-microblaze.cmake
#                     ^
#                     L ${OPLK_BASE_DIR}
#
#
# (c)2023 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

message(STATUS "Adding MN/CN library targets for Xilinx FreeRTOS/Microblaze")

################################################################################
# Options for MN and CN libraries
option(CONFIG_MN "Compile managing (MN) or controlled (CN, default) node variant of the openPOWERLINK library" OFF)

if (CONFIG_MN)
  option(CFG_COMPILE_LIB_MN "Compile openPOWERLINK MN library" ON)
  option(CFG_COMPILE_LIB_CN "Compile openPOWERLINK CN library" OFF)
else()
  option(CFG_COMPILE_LIB_MN "Compile openPOWERLINK MN library" OFF)
  option(CFG_COMPILE_LIB_CN "Compile openPOWERLINK CN library" ON)
endif()

################################################################################
# Add library subdirectories and hardware library path

# MN libraries
if(CFG_COMPILE_LIB_MN)
  add_subdirectory(proj/freertos/liboplkmn)
else()
  unset(CFG_COMPILE_LIB_MN_HW_PATH CACHE)
endif()

# CN libraries
if(CFG_COMPILE_LIB_CN)
  add_subdirectory(proj/freertos/liboplkcn)
else()
  unset(CFG_COMPILE_LIB_CN_HW_PATH CACHE)
endif()
