# Building CDI2SIM

Important directory handles are

| Handle | Path | Description |
| ------ | ---- | ----------- |
| `<QUARTUS>` | | Quartus and EDS installation path |
| `<CDI2SIM>` | | Your project directory |
| `<FPGA>` | `<CDI2SIM>/FPGA` | FPGA design |
| `<SDK>` | `CDI2SIM>/angstrom-sdk` | Angstrom-generated SDK |
| `<OPL>` | `<CDIS2SIM>/openPOWERLINK_V2` | openPOWERLINK module checkout |

## Patching Quartus

Generating the BSP for the Nios II driver daemon fails, because no region
information is available for `address_span_extender_cpu_bridge`. As described by
[NIOSII using the FPGA-to-HPS SDRAM Bridge via Address Span Extender](https://alteraforum.com/forum/showthread.php?t=43940),
this can be resolved either by editing the generated `.sopcinfo` file or by uncommenting two lines in
`<QUARTUS>/ip/altera/merlin/address_span_extender/altera_address_span_extender_hw.tcl`:

* set_interface_assignment windowed_slave embeddedsw.configuration.isMemoryDevice 1
* set_interface_assignment windowed_slave embeddedsw.configuration.affectsTransactionsOnMasters "expanded_master"

## Building SPL, U-Boot, Kernel, root filesystem, device tree, and SDK

SPL and device tree are build in directory `<CDI2SIM>/BSP_HPS`

```bash
$ make
```

The SPL image, ready to be dd(1)'d onto partition A2, can be found in
`<CDI2SIM>/BSP_HPS/preloader-mkpimage.bin`, the device tree BLOB in
`<CDI2SIM>/BSP_HPS/socfpga.dtb`.

U-Boot, Kernel, root filesystem and SDK are build with Angstrom/Yocto:

```bash
$ cd <CDISIM>/angstrom-build
$ export PATH=`pwd`:$PATH
$ MACHINE=cyclone5 source ./setup-environment
$ bitbake virtual/bootloader
$ bitbake virtual/kernel
$ bitbake cdi2sim-image
$ bitbake -c populate_sdk cdi2sim-image
```

After installing the generated SDK, the kernel build scripts must be prepared
in order to be able to build the kernel module in a later step:

```bash
$ source <SDK>/environment-setup-armv7at2hf-neon-angstrom-linux-gnueabi
$ cd $SDKTARGETSYSROOT/usr/src/kernel
$ make CROSS_COMPILE=$TARGET_PREFIX scripts
```

## Building the PCP Driver Daemon

For the PCP driver, a generator script exists in
`<OPL>/drivers/altera-nios2/drv-daemon/build`. Execute it in a Nios2 command
shell with `--board` pointing to the board settings in
`<OPL>/hardware/boards/altera-c5soc/mn-soc-shmem-gpio` and `--sopcinfo`
pointing to the FPGA design

```bash
$ ./create-this-app --debug \
    --board ../../../../hardware/boards/altera-c5soc/mn-soc-shmem-gpio \
    --sopcinfo <FPGA>/main_soc_nios_openmac.sopcinfo
```

In order to build the PCP daemon for the Enclustra Mars MA3 variant, add
the `--variant` option to the command line:

```bash
$ ./create-this-app --debug --variant enclustra \
    --board ../../../../hardware/boards/altera-c5soc/mn-soc-shmem-gpio \
    --sopcinfo <FPGA>/main_soc_nios_openmac.sopcinfo
```

To generate the PCP driver for the CN use the following command for
Shiratech/Spark 102:

```bash
$ ./create-this-app --debug \
    --board ../../../../hardware/boards/altera-c5soc/cn-soc-shmem-gpio \
    --sopcinfo <FPGA>/main_soc_nios_openmac.sopcinfo
```

and for the Enclustra/Mars MA3

```bash
$ ./create-this-app --debug --variant enclustra \
    --board ../../../../hardware/boards/altera-c5soc/cn-soc-shmem-gpio \
    --sopcinfo <FPGA>/main_soc_nios_openmac.sopcinfo
```

## Building the Linux Kernel Module

The Linux kernel module sources for the Altera Cyclone 5 shared memory driver
are in `<OPL>/drivers/linux/drv_kernelmod_c5arm`. Change into the `build` directory
and generate the cmake(1) compile infrastructure:

```bash
$ source <SDK>/environment-setup-armv7at2hf-neon-angstrom-linux-gnueabi
$ cmake -G "Unix Makefiles" .. -DCMAKE_BUILD_TYPE=Debug \
    -DCFG_OPLK_MN=TRUE \
    -DCMAKE_TOOLCHAIN_FILE=../../../cmake/toolchain-angstrom-c5socarm-eabi-gnu.cmake \
    -DCFG_KERNEL_DIR=$SDKTARGETSYSROOT/usr/src/kernel
$ make
$make install
```

The kernel module is copied to `<OPL>/bin/linux/alterac5arm/oplkdrv_kernelmodule_c5arm/oplmnc5armint.ko`
and can be installed with `insmod(8)` on the HPS. If Linux/HPS controls the
PCP/Nios2 processor, the Nios2 ELF load must be added as module parameter in
order to reset and properly load the co-processor from the HPS:

```bash
$ insmod ../oplkdrv_kernelmodule_c5arm/oplkmnc5armintf.ko \
    pcpLoad=/drv_daemon.elf
```

Use absolute pathnames as argument to `pcpLoad` for consistent results.

To build the kernel module for the CN, the command line parameter
`CFG_OPLK_MN` has to be set to `FALSE` explicitly:

```bash
$ cmake -G "Unix Makefiles" .. -DCMAKE_BUILD_TYPE=Debug \
    -DCFG_OPLK_MN=FALSE \
    -DCFG_KERNEL_DIR=$SDKTARGETSYSROOT/usr/src/kernel \
    -DCMAKE_TOOLCHAIN_FILE=../../../cmake/toolchain-angstrom-c5socarm-eabi-gnu.cmake
```

## Building the Linux Userland Application Libraries

The stack libraries are build with the cross-compile toolchain in
`<OPL>/stack/build/linux`. Change into the directroy and generate the libraries:

```bash
$ source <SDK>/environment-setup-armv7at2hf-neon-angstrom-linux-gnueabi
$ cmake -G "Unix Makefiles" ../.. -DCMAKE_BUILD_TYPE=Debug \
    -DCFG_COMPILE_LIB_MNAPP_C5ARMINTF=ON \
    -DCFG_COMPILE_LIB_MNAPP_ZYNQINTF=OFF \
    -DCFG_COMPILE_LIB_MNAPP_PCIEINTF=OFF \
    -DCMAKE_TOOLCHAIN_FILE=../../../cmake/toolchain-angstrom-c5socarm-eabi-gnu.cmake
$ make
$ make install
```

The generated libraries (for static linking) can then be found in
`<OPL>`/stack/lib/linux/altrac5arm

## Building the Managing and Controlled Node Console Demo Application

The MN and CN console demo applications are built in
`<OPL>/apps/demo-mn-console/build/linux` and `<OPL>/apps/demo-cn-console/build/linux`.

```bash
$ source <SDK>/environment-setup-armv7at2hf-neon-angstrom-linux-gnueabi
$ cd <OPL>/apps/demo-mn-console/build/linux
$ cmake -G "Unix Makefiles" ../.. -DCMAKE_BUILD_TYPE=Debug \
    -DCFG_BUILD_KERNEL_STACK="Kernel stack on Cyclone PCP" \
    -DCMAKE_TOOLCHAIN_FILE=../../../../cmake/toolchain-angstrom-c5socarm-eabi-gnu.cmake
$ make
$ make install
```

```bash
$ source <SDK>/environment-setup-armv7at2hf-neon-angstrom-linux-gnueabi
$ cd <OPL>/apps/demo-cn-console/build/linux
$ cmake -G "Unix Makefiles" ../.. -DCMAKE_BUILD_TYPE=Debug \
    -DCFG_BUILD_KERNEL_STACK="Kernel stack on Cyclone PCP" \
    -DCMAKE_TOOLCHAIN_FILE=../../../../cmake/toolchain-angstrom-c5socarm-eabi-gnu.cmake
$ make
$ make install
```

After installation, the generated demo applications can be found in
`<OPL>/bin/linux/alterac5arm`
