###SYSTEM CLOCK and RESET
set_property PACKAGE_PIN F19 [get_ports reset]
set_property IOSTANDARD LVCMOS25 [get_ports reset]
set_property PIO_DIRECTION INPUT [get_ports reset]
########################################################################

#####ON BOARD LEDS
set_property PACKAGE_PIN P17 [get_ports {leds_6bit_tri_o[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {leds_6bit_tri_o[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {leds_6bit_tri_o[0]}]
set_property PACKAGE_PIN P18 [get_ports {leds_6bit_tri_o[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {leds_6bit_tri_o[1]}]
set_property PIO_DIRECTION OUTPUT [get_ports {leds_6bit_tri_o[1]}]
set_property PACKAGE_PIN W10 [get_ports {leds_6bit_tri_o[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {leds_6bit_tri_o[2]}]
set_property PIO_DIRECTION OUTPUT [get_ports {leds_6bit_tri_o[2]}]
set_property PACKAGE_PIN V7 [get_ports {leds_6bit_tri_o[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {leds_6bit_tri_o[3]}]
set_property PIO_DIRECTION OUTPUT [get_ports {leds_6bit_tri_o[3]}]
set_property PACKAGE_PIN W5 [get_ports {leds_6bit_tri_o[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {leds_6bit_tri_o[4]}]
set_property PIO_DIRECTION OUTPUT [get_ports {leds_6bit_tri_o[4]}]
set_property PACKAGE_PIN W17 [get_ports {leds_6bit_tri_o[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {leds_6bit_tri_o[5]}]
set_property PIO_DIRECTION OUTPUT [get_ports {leds_6bit_tri_o[5]}]
########################################################################

####POWERLINK STATUS LEDS
set_property PACKAGE_PIN D15 [get_ports {powerlink_led_tri_o[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {powerlink_led_tri_o[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {powerlink_led_tri_o[0]}]
set_property PACKAGE_PIN E15 [get_ports {powerlink_led_tri_o[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {powerlink_led_tri_o[1]}]
set_property PIO_DIRECTION OUTPUT [get_ports {powerlink_led_tri_o[1]}]
########################################################################

####POWERLINK NODESWITCH
set_property PACKAGE_PIN W7 [get_ports {node_switches_tri_io[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {node_switches_tri_io[0]}]
set_property PIO_DIRECTION BIDIR [get_ports {node_switches_tri_io[0]}]
set_property PACKAGE_PIN W6 [get_ports {node_switches_tri_io[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {node_switches_tri_io[1]}]
set_property PIO_DIRECTION BIDIR [get_ports {node_switches_tri_io[1]}]
########################################################################

###########FMC (1)
###MDIO PIN MAPPING PHY1
set_property PACKAGE_PIN B20 [get_ports {axi_powerlink_0_PHY0_PWRDWN_INT_n_pin[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {axi_powerlink_0_PHY0_PWRDWN_INT_n_pin[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {axi_powerlink_0_PHY0_PWRDWN_INT_n_pin[0]}]
set_property PACKAGE_PIN N15 [get_ports {smi_mdio_io[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {smi_mdio_io[0]}]
set_property PIO_DIRECTION BIDIR [get_ports {smi_mdio_io[0]}]
set_property PACKAGE_PIN P15 [get_ports {SMI_mdc[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {SMI_mdc[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {SMI_mdc[0]}]
set_property PACKAGE_PIN P20 [get_ports {oSmi_nPhyRst[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {oSmi_nPhyRst[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {oSmi_nPhyRst[0]}]

###MDIO PIN MAPPING PHY2
set_property PACKAGE_PIN R21 [get_ports {axi_powerlink_0_PHY1_PWRDWN_INT_n_pin[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {axi_powerlink_0_PHY1_PWRDWN_INT_n_pin[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {axi_powerlink_0_PHY1_PWRDWN_INT_n_pin[0]}]
set_property PACKAGE_PIN N17 [get_ports {smi_mdio_io[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {smi_mdio_io[1]}]
set_property PIO_DIRECTION BIDIR [get_ports {smi_mdio_io[1]}]
set_property PACKAGE_PIN M21 [get_ports {SMI_mdc[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {SMI_mdc[1]}]
set_property PIO_DIRECTION OUTPUT [get_ports {SMI_mdc[1]}]
set_property PACKAGE_PIN J18 [get_ports {oSmi_nPhyRst[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {oSmi_nPhyRst[1]}]
set_property PIO_DIRECTION OUTPUT [get_ports {oSmi_nPhyRst[1]}]

####MII TX/Rx PIN MAPPING
## PHY 1 (FMC1-ISMNET J2)
#TX
set_property PACKAGE_PIN M19 [get_ports {MII_tx_clk[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_tx_clk[0]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_tx_clk[0]}]
set_property PACKAGE_PIN C22 [get_ports {MII_tx_en[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_tx_en[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_tx_en[0]}]
set_property PACKAGE_PIN B15 [get_ports {MII_txd[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[3]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[3]}]
set_property PACKAGE_PIN A22 [get_ports {MII_txd[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[2]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[2]}]
set_property PACKAGE_PIN D22 [get_ports {MII_txd[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[1]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[1]}]
set_property PACKAGE_PIN B17 [get_ports {MII_txd[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[0]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[0]}]
#RX
set_property PACKAGE_PIN L18 [get_ports {MII_rx_clk[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rx_clk[0]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rx_clk[0]}]
set_property PACKAGE_PIN R16 [get_ports {MII_rx_dv[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rx_dv[0]}]
set_property PULLDOWN true [get_ports {MII_rx_dv[0]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rx_dv[0]}]
set_property PACKAGE_PIN J17 [get_ports {MII_rx_er[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rx_er[0]}]
set_property PULLUP true [get_ports {MII_rx_er[0]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rx_er[0]}]
set_property PACKAGE_PIN F22 [get_ports {MII_rxd[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[3]}]
set_property PULLDOWN true [get_ports {MII_rxd[3]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[3]}]
set_property PACKAGE_PIN C17 [get_ports {MII_rxd[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[2]}]
set_property PULLUP true [get_ports {MII_rxd[2]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[2]}]
set_property PACKAGE_PIN C15 [get_ports {MII_rxd[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[1]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[1]}]
set_property PACKAGE_PIN A21 [get_ports {MII_rxd[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[0]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[0]}]

####MII TX/Rx PIN MAPPING
## PHY 1 (FMC1-ISMNET J2)
#TX
set_property PACKAGE_PIN B19 [get_ports {MII_tx_clk[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_tx_clk[1]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_tx_clk[1]}]
set_property PACKAGE_PIN C18 [get_ports {MII_tx_en[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_tx_en[1]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_tx_en[1]}]
set_property PACKAGE_PIN E18 [get_ports {MII_txd[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[7]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[7]}]
set_property PACKAGE_PIN F18 [get_ports {MII_txd[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[6]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[6]}]
set_property PACKAGE_PIN G16 [get_ports {MII_txd[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[5]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[5]}]
set_property PACKAGE_PIN G15 [get_ports {MII_txd[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_txd[4]}]
set_property PIO_DIRECTION OUTPUT [get_ports {MII_txd[4]}]
#RX
set_property PACKAGE_PIN K19 [get_ports {MII_rx_clk[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rx_clk[1]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rx_clk[1]}]
set_property PACKAGE_PIN M22 [get_ports {MII_rx_dv[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rx_dv[1]}]
set_property PULLDOWN true [get_ports {MII_rx_dv[1]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rx_dv[1]}]
set_property PACKAGE_PIN J21 [get_ports {MII_rx_er[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rx_er[1]}]
set_property PULLUP true [get_ports {MII_rx_er[1]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rx_er[1]}]
set_property PACKAGE_PIN J15 [get_ports {MII_rxd[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[7]}]
set_property PULLUP true [get_ports {MII_rxd[7]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[7]}]
set_property PACKAGE_PIN K15 [get_ports {MII_rxd[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[6]}]
set_property PULLDOWN true [get_ports {MII_rxd[6]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[6]}]
set_property PACKAGE_PIN M15 [get_ports {MII_rxd[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[5]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[5]}]
set_property PACKAGE_PIN R20 [get_ports {MII_rxd[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {MII_rxd[4]}]
set_property PIO_DIRECTION INPUT [get_ports {MII_rxd[4]}]
########################################################################

####FMC (2)
### Connector (FMC-105-DEBUG J1)
#HOST_BENCHMARK
set_property PACKAGE_PIN U17 [get_ports {host_benchmark_pio_tri_io[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[0]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[0]}]
set_property PACKAGE_PIN V17 [get_ports {host_benchmark_pio_tri_io[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[1]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[1]}]
set_property PACKAGE_PIN T21 [get_ports {host_benchmark_pio_tri_io[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[2]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[2]}]
set_property PACKAGE_PIN U21 [get_ports {host_benchmark_pio_tri_io[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[3]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[3]}]
set_property PACKAGE_PIN AA17 [get_ports {host_benchmark_pio_tri_io[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[4]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[4]}]
set_property PACKAGE_PIN AB17 [get_ports {host_benchmark_pio_tri_io[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[5]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[5]}]
set_property PACKAGE_PIN U15 [get_ports {host_benchmark_pio_tri_io[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[6]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[6]}]
set_property PACKAGE_PIN U16 [get_ports {host_benchmark_pio_tri_io[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {host_benchmark_pio_tri_io[7]}]
set_property PIO_DIRECTION BIDIR [get_ports {host_benchmark_pio_tri_io[7]}]
########################################################################

#####PCP_BENCHMARK
set_property PACKAGE_PIN V14 [get_ports {benchmark_pio_tri_io[0]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[0]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[0]}]
set_property PACKAGE_PIN V15 [get_ports {benchmark_pio_tri_io[1]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[1]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[1]}]
set_property PACKAGE_PIN AA16 [get_ports {benchmark_pio_tri_io[2]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[2]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[2]}]
set_property PACKAGE_PIN AB16 [get_ports {benchmark_pio_tri_io[3]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[3]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[3]}]
set_property PACKAGE_PIN V13 [get_ports {benchmark_pio_tri_io[4]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[4]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[4]}]
set_property PACKAGE_PIN W13 [get_ports {benchmark_pio_tri_io[5]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[5]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[5]}]
set_property PACKAGE_PIN AB19 [get_ports {benchmark_pio_tri_io[6]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[6]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[6]}]
set_property PACKAGE_PIN AB20 [get_ports {benchmark_pio_tri_io[7]}]
set_property IOSTANDARD LVCMOS25 [get_ports {benchmark_pio_tri_io[7]}]
set_property PIO_DIRECTION BIDIR [get_ports {benchmark_pio_tri_io[7]}]
########################################################################

#VIRTUAL CLOCK
create_clock -period 10.000 -name clock_out1 -add [get_nets system_i/clock_generator/clk_out1]
create_clock -period 20.000 -name clock_out2 -add [get_nets system_i/clock_generator/clk_out2]

#INPUT DELAY
set_input_delay -clock [get_clocks clk_fpga_0] -max -add_delay 2.000 [get_ports {node_switches_tri_io[*]}]
set_input_delay -clock [get_clocks clk_fpga_0] -min -add_delay 1.000 [get_ports {node_switches_tri_io[*]}]
set_input_delay -clock [get_clocks clk_fpga_0] -max -add_delay 2.000 [get_ports {host_benchmark_pio_tri_io[*]}]
set_input_delay -clock [get_clocks clk_fpga_0] -min -add_delay 1.000 [get_ports {host_benchmark_pio_tri_io[*]}]
set_input_delay -clock [get_clocks clock_out1] -max -add_delay 2.000 [get_ports {benchmark_pio_tri_io[*]}]
set_input_delay -clock [get_clocks clock_out1] -min -add_delay 1.000 [get_ports {benchmark_pio_tri_io[*]}]
set_input_delay -clock [get_clocks clock_out2] -max -add_delay 2.000 [get_ports reset]
set_input_delay -clock [get_clocks clock_out2] -min -add_delay 1.000 [get_ports reset]
set_input_delay -clock [get_clocks clock_out2] -max -add_delay 2.000 [get_ports {smi_mdio_io[*]}]
set_input_delay -clock [get_clocks clock_out2] -min -add_delay 1.000 [get_ports {smi_mdio_io[*]}]

#OUTPUT DELAY
set_output_delay -clock [get_clocks clk_fpga_0] -max -add_delay 1.000 [get_ports {leds_6bit_tri_o[*]}]
set_output_delay -clock [get_clocks clk_fpga_0] -min -add_delay 0.500 [get_ports {leds_6bit_tri_o[*]}]
set_output_delay -clock [get_clocks clk_fpga_0] -max -add_delay 1.000 [get_ports {host_benchmark_pio_tri_io[*]}]
set_output_delay -clock [get_clocks clk_fpga_0] -min -add_delay 0.500 [get_ports {host_benchmark_pio_tri_io[*]}]
set_output_delay -clock [get_clocks clk_fpga_0] -max -add_delay 1.000 [get_ports {node_switches_tri_io[*]}]
set_output_delay -clock [get_clocks clk_fpga_0] -min -add_delay 0.500 [get_ports {node_switches_tri_io[*]}]
set_output_delay -clock [get_clocks clock_out1] -max -add_delay 2.000 [get_ports {benchmark_pio_tri_io[*]}]
set_output_delay -clock [get_clocks clock_out1] -min -add_delay 1.000 [get_ports {benchmark_pio_tri_io[*]}]
set_output_delay -clock [get_clocks clock_out1] -max -add_delay 2.000 [get_ports {powerlink_led_tri_o[*]}]
set_output_delay -clock [get_clocks clock_out1] -min -add_delay 1.000 [get_ports {powerlink_led_tri_o[*]}]
set_output_delay -clock [get_clocks clock_out2] -max -add_delay 2.000 [get_ports {smi_mdio_io[*]}]
set_output_delay -clock [get_clocks clock_out2] -min -add_delay 1.000 [get_ports {smi_mdio_io[*]}]
set_output_delay -clock [get_clocks clock_out2] -max -add_delay 2.000 [get_ports {oSmi_nPhyRst[*]}]
set_output_delay -clock [get_clocks clock_out2] -min -add_delay 1.000 [get_ports {oSmi_nPhyRst[*]}]
set_output_delay -clock [get_clocks clock_out2] -max -add_delay 2.000 [get_ports {SMI_mdc[*]}]
set_output_delay -clock [get_clocks clock_out2] -min -add_delay 1.000 [get_ports {SMI_mdc[*]}]

#MDIO Delay contraints

#MII - RX DELAY CONSTRAINTS:
create_clock -period 40.000 -name clk_mii0_rx -add [get_ports {MII_rx_clk[0]}]
create_clock -period 40.000 -name clk_mii1_rx -add [get_ports {MII_rx_clk[1]}]
set_property IOB TRUE [get_ports {{MII_rxd[*]} {MII_rx_dv[*]} {MII_rx_er[*]}}]
set_input_delay -clock [get_clocks clk_mii0_rx] -min -add_delay 10.000 [get_ports {MII_rx_dv[0]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -max -add_delay 30.000 [get_ports {MII_rx_dv[0]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -min -add_delay 10.000 [get_ports {MII_rx_dv[1]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -max -add_delay 30.000 [get_ports {MII_rx_dv[1]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -min -add_delay 10.000 [get_ports {MII_rx_er[0]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -max -add_delay 30.000 [get_ports {MII_rx_er[0]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -min -add_delay 10.000 [get_ports {MII_rx_er[1]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -max -add_delay 30.000 [get_ports {MII_rx_er[1]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -min -add_delay 10.000 [get_ports {MII_rxd[0]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -max -add_delay 30.000 [get_ports {MII_rxd[0]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -min -add_delay 10.000 [get_ports {MII_rxd[1]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -max -add_delay 30.000 [get_ports {MII_rxd[1]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -min -add_delay 10.000 [get_ports {MII_rxd[2]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -max -add_delay 30.000 [get_ports {MII_rxd[2]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -min -add_delay 10.000 [get_ports {MII_rxd[3]}]
set_input_delay -clock [get_clocks clk_mii0_rx] -max -add_delay 30.000 [get_ports {MII_rxd[3]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -min -add_delay 10.000 [get_ports {MII_rxd[4]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -max -add_delay 30.000 [get_ports {MII_rxd[4]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -min -add_delay 10.000 [get_ports {MII_rxd[5]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -max -add_delay 30.000 [get_ports {MII_rxd[5]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -min -add_delay 10.000 [get_ports {MII_rxd[6]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -max -add_delay 30.000 [get_ports {MII_rxd[6]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -min -add_delay 10.000 [get_ports {MII_rxd[7]}]
set_input_delay -clock [get_clocks clk_mii1_rx] -max -add_delay 30.000 [get_ports {MII_rxd[7]}]

#MII - TX DELAY CONTRAINTS:
create_clock -period 40.000 -name clk_mii0_tx -add [get_ports {MII_tx_clk[0]}]
create_clock -period 40.000 -name clk_mii1_tx -add [get_ports {MII_tx_clk[1]}]
set_property IOB TRUE [get_ports {{MII_txd[*]} {MII_tx_en[*]}}]
set_output_delay -clock [get_clocks clk_mii0_tx] -min -add_delay 0.000 [get_ports {MII_txd[0]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -max -add_delay 10.000 [get_ports {MII_txd[0]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -min -add_delay 0.000 [get_ports {MII_txd[1]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -max -add_delay 10.000 [get_ports {MII_txd[1]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -min -add_delay 0.000 [get_ports {MII_txd[2]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -max -add_delay 10.000 [get_ports {MII_txd[2]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -min -add_delay 0.000 [get_ports {MII_txd[3]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -max -add_delay 10.000 [get_ports {MII_txd[3]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -min -add_delay 0.000 [get_ports {MII_txd[4]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -max -add_delay 10.000 [get_ports {MII_txd[4]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -min -add_delay 0.000 [get_ports {MII_txd[5]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -max -add_delay 10.000 [get_ports {MII_txd[5]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -min -add_delay 0.000 [get_ports {MII_txd[6]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -max -add_delay 10.000 [get_ports {MII_txd[6]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -min -add_delay 0.000 [get_ports {MII_txd[7]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -max -add_delay 10.000 [get_ports {MII_txd[7]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -min -add_delay 0.000 [get_ports {MII_tx_en[0]}]
set_output_delay -clock [get_clocks clk_mii0_tx] -max -add_delay 10.000 [get_ports {MII_tx_en[0]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -min -add_delay 0.000 [get_ports {MII_tx_en[1]}]
set_output_delay -clock [get_clocks clk_mii1_tx] -max -add_delay 10.000 [get_ports {MII_tx_en[1]}]

####GENERATED_CLOCK & CLOCK GROUPS generated from Constraints Wizard
create_generated_clock -name {system_i/proc_sys_rst/peripheral_aresetn[0]} -source [get_pins system_i/clock_generator/inst/clkout2_buf/O] -divide_by 4 -add -master_clock clock_out2 [get_pins {system_i/proc_sys_rst/U0/ACTIVE_LOW_PR_OUT_DFF[0].peripheral_aresetn_reg[0]/Q}]

set_clock_groups -asynchronous -group [get_clocks {system_i/proc_sys_rst/peripheral_aresetn[0]}] -group [get_clocks clock_out1]
set_clock_groups -asynchronous -group [get_clocks clock_out2] -group [get_clocks clk_mii0_rx]
set_clock_groups -asynchronous -group [get_clocks clock_out2] -group [get_clocks clk_mii1_rx]
set_clock_groups -asynchronous -group [get_clocks clk_mii0_tx] -group [get_clocks clock_out2]
set_clock_groups -asynchronous -group [get_clocks clk_mii1_tx] -group [get_clocks clock_out2]
set_clock_groups -asynchronous -group [get_clocks clock_out1] -group [get_clocks clock_out2]
set_clock_groups -asynchronous -group [get_clocks clock_out2] -group [get_clocks clock_out1]
set_clock_groups -asynchronous -group [get_clocks {system_i/proc_sys_rst/peripheral_aresetn[0]}] -group [get_clocks clk_mii0_rx]
set_clock_groups -asynchronous -group [get_clocks {system_i/proc_sys_rst/peripheral_aresetn[0]}] -group [get_clocks clk_mii0_tx]
set_clock_groups -asynchronous -group [get_clocks {system_i/proc_sys_rst/peripheral_aresetn[0]}] -group [get_clocks clk_mii1_rx]
set_clock_groups -asynchronous -group [get_clocks {system_i/proc_sys_rst/peripheral_aresetn[0]}] -group [get_clocks clk_mii1_tx]
set_false_path -reset_path -from [get_clocks clk_mii0_rx] -to [get_clocks clk_mii0_rx]
set_false_path -reset_path -from [get_clocks clk_mii1_rx] -to [get_clocks clk_mii1_rx]
########################################################################