Contributing to openPOWERLINK {#page_contribution}
========

The following is a set of guidelines for contributing to the openPOWERLINK Real-Time Ethernet stack.

## Submitting Issues

If you can't find an existing issue that describes your bug,
please submit an issue report using the following guidelines.

* Do not submit multiple bugs in the same issue.
* Describe your bug as detailed as possible, so someone else will be able to
  successfully reproduce the issue and find a fix.
  * The version of the openPOWERLINK stack
  * Operating system (including kernel version and RT-Patch if applicable)
  * Hardware platform
  * Steps to reproduce the bug
* Other things that might help resolving your issue:
  * openPOWERLINK stack log from your console
  * A log of the kernel buffer messages (dmesg command)
  * Screenshots


## Submitting Pull Requests

* Follow the [coding guidelines defined in docs](\ref page_coding).
* Write documentation in [Doxygen](\ref sect_coding_comments)
* Follow the commit message guidelines below.

### Git Commits

Creating reasonable commit messages makes using and collaborating with Git a lot easier.
As a general rule, your messages should start with a single line consisting of no more than 72 characters.
It shall describe the changeset concisely, followed by a blank line, followed by a more detailed explanation.

~~~
[TAG] short summary of changes

More detailed explanatory text, if necessary. In some contexts, the
first line is treated as the subject of an email and the rest of the
text as the body. The blank line separating the summary from the body
is critical (unless you omit the body entirely); tools like rebase
can get confused if you run the two together.

Further paragraphs come after blank lines.
 - Bullet points are okay, too
 - Typically a hyphen or asterisk is used for the bullet, preceded by a single space,
   with blank lines in between, but conventions vary here

Resolves: #0815
~~~
(The above template is based on template written by Tim Pope at tpope.net)

#### Message title

The first line must be prefixed with a tag describing the topic.
Keep the whole line below 50 characters if possible, but below 72 in any case!
Valid tags are:
* **[MERGE]**: Used for merge commits.
* **[FEATURE]**: A new feature (also small additions) is added (or removed).
* **[FIX]**: A bug is fixed.
* **[TASK]**: Anything not covered by the above categories, e.g. coding style cleanup.

#### Message Body

Write your commit message in the present tense: "Fix bug" and not "Fixed bug."
This convention matches up with commit messages generated by commands like git merge and git revert.
Wrap the lines after 72 characters

#### Relationships

If the change is related to an issue entry, please add the reference to the issue tracker.
For example if it is a bugfix for Bug #1234:
Resolves: #1234

#### Changes

Only handle one specific topic in a single change.
Please create separate commits for moving or renaming of files and the actual changes to the files.
With monolithic patches the changes to the sources are opaque.