#-------------------------------------------------------------------------------
#
# CMake(1) Toolchain file for Xilinx Zynq Ultrascale+ Bare-Metal
#
# (c)2018 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

# allow overriding SDK path on the command line
set(VIVADO_SDK_DIR  /opt/Xilinx/SDK/2018.2                               CACHE STRING "Xilinx Vivado SDK path")
set(CROSS_TOOLS_DIR "${VIVADO_SDK_DIR}/gnu/aarch64/lin/aarch64-none/bin" CACHE STRING "Xilinx Vivado Cross Compile Toolchain")

# set name and version of target platform: 'Generic' for Bare-Metal
set(CMAKE_SYSTEM_NAME Generic)
set(CMAKE_SYSTEM_VERSION 1)

# target processor and ABI
set(CMAKE_SYSTEM_PROCESSOR Ultrascale)

# avoid running the linker during compiler detection (cannot cross-link w/o linker script)
if (CMAKE_VERSION VERSION_LESS 3.6)
  set(CMAKE_C_COMPILER_WORKS   1)
  set(CMAKE_CXX_COMPILER_WORKS 1)
else()
  set(CMAKE_TRY_COMPILE_TARGET_TYPE STATIC_LIBRARY)
endif()

# compiler, linker, ...
set(CMAKE_C_COMPILER   "${CROSS_TOOLS_DIR}/aarch64-none-elf-gcc")
set(CMAKE_CXX_COMPILER "${CROSS_TOOLS_DIR}/aarch64-none-elf-g++")

set(CROSS_FLAGS     "-mcpu=cortex-a53 -mtune=cortex-a53 -fmessage-length=0 -g")
set(CMAKE_C_FLAGS   "${CROSS_FLAGS} ${CMAKE_C_FLAGS}"   CACHE STRING "")
set(CMAKE_CXX_FLAGS "${CROSS_FLAGS} ${CMAKE_CXX_FLAGS}" CACHE STRING "")
set(CMAKE_LD_FLAGS  "${CROSS_FLAGS} ${CMAKE_LD_FLAGS}"  CACHE STRING "")
set(CMAKE_AS_FLAGS  "${CROSS_FLAGS} ${CMAKE_AS_FLAGS}"  CACHE STRING "")
