#-------------------------------------------------------------------------------
#
# toolchain-microblaze-xilinx-freertos-elf.cmake
#
# CMake(1) toolchain file for Xilinx Vitis Microblaze 32b FreeRTOS
#
# The toolchain file for the Xilinx/AMD and Altera/Intel softcore follow the
# GNU compiler targer convention:
#
#     <arch>-<vendor>-<os>-<abi>
#     +      +        +     +
#     |      |        |     L elf, Full Microblaze ABI spec in UG081
#     |      |        L FreeRTOS
#     |      L Xilinx
#     L Microblaze
#
# (c)2023 AIT Austrian Institute of Technology
#-------------------------------------------------------------------------------

# target processor and ABI
set(CMAKE_SYSTEM_PROCESSOR "Microblaze")

# set name and version of target platform: must be 'Generic' for bare metal and also for FreeRTOS
set(CMAKE_SYSTEM_NAME "Generic")
set(CMAKE_SYSTEM_VERSION 1)

# indicate that this builds for FreeRTOS
set(FREERTOS ON CACHE BOOL "build OPLK library for FreeRTOS/Microblaze") 

# specify the Microblaze cross compiler tools, assuming they are on the Vitis supplied PATH
set(CMAKE_C_COMPILER       "mb-gcc")
set(CMAKE_CXX_COMPILER     "mb-g++")
set(CMAKE_ASM-ATT_COMPILER "mb-as")
set(CMAKE_ASM_COMPILER     "mb-as")
set(CMAKE_AR               "mb-ar")

# set global Microblaze processor options
set(CROSS_FLAGS          "-fmessage-length=0 -mlittle-endian -mcpu=v11.0 -mxl-barrel-shift -mxl-soft-mul -Wl,--no-relax -ffunction-sections -fdata-sections")
set(CMAKE_C_FLAGS_INIT   ${CROSS_FLAGS} CACHE STRING "initial C cross compile flags")
set(CMAKE_CXX_FLAGS_INIT ${CROSS_FLAGS} CACHE STRING "initial C++ cross compile flags")
set(CMAKE_AS_FLAGS_INIT  ${CROSS_FLAGS} CACHE STRING "initial cross assembler flags")
