################################################################################
#
# CMake target configuration file for Altera Cyclone V SoC ARM, Angstrom/Yocto
# cross-toolchain
#
# Copyright (c) 2017, AIT
# Copyright (c) 2015, Kalycito Infotech Private Limited
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holders nor the
#       names of its contributors may be used to endorse or promote products
#       derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDERS BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
################################################################################

################################################################################
# Name of the target platform
set(CMAKE_SYSTEM Altera-c5arm)
set(CMAKE_SYSTEM_NAME Linux)
set(CMAKE_SYSTEM_PROCESSOR alterac5arm)

# Version of the system
set(CMAKE_SYSTEM_VERSION 1)

# specify the cross compiler
set(CMAKE_C_COMPILER       arm-angstrom-linux-gnueabi-gcc)
set(CMAKE_CXX_COMPILER     arm-angstrom-linux-gnueabi-g++)
set(CMAKE_ASM-ATT_COMPILER arm-angstrom-linux-gnueabi-as)

# the toolchain file is processed before the project() command which might, during compiler detection, clobber
# the compile flags. Avoid this, by putting the mandatory x-chain flags into the cache
set(CMAKE_C_FLAGS   "-march=armv7-a -mthumb -mfpu=neon -mfloat-abi=hard --sysroot=$ENV{SDKTARGETSYSROOT} ${CMAKE_C_FLAGS}"   CACHE STRING "")
set(CMAKE_CXX_FLAGS "-march=armv7-a -mthumb -mfpu=neon -mfloat-abi=hard --sysroot=$ENV{SDKTARGETSYSROOT} ${CMAKE_CXX_FLAGS}" CACHE STRING "")

# list of root paths to search
set(CMAKE_FIND_ROOT_PATH $ENV{SDKTARGETSYSROOT})

# search for programs in the build host directories
set(CMAKE_FIND_ROOT_PATH_MODE_PROGRAM NEVER)

# for libraries and headers in the target directories
set(CMAKE_FIND_ROOT_PATH_MODE_LIBRARY BOTH)
set(CMAKE_FIND_ROOT_PATH_MODE_INCLUDE ONLY)

# cross compiler directives
set(MAKE_KERNEL_ARCH arm)
set(MAKE_KERNEL_CROSS_COMPILE arm-angstrom-linux-gnueabi-)
